/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.RepeatFilter;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.out.CsOutResultOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsPhysicsInventoryTotalEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutNoticeOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutResultOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutResultOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsPhysicsWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsPhysicsInventoryTotalMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutNoticeOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutResultOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutResultOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsPhysicsWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csOutResultOrderService")
public class CsOutResultOrderServiceImpl
implements ICsOutResultOrderService {
    private static Logger logger = LoggerFactory.getLogger(CsOutResultOrderServiceImpl.class);
    @Autowired
    private CsOutResultOrderDas csOutResultOrderDas;
    @Resource
    private CsOutResultOrderMapper csOutResultOrderMapper;
    @Resource
    private CsOutNoticeOrderMapper csOutNoticeOrderMapper;
    @Resource
    private CsOutResultOrderDetailMapper csOutResultOrderDetailMapper;
    @Resource
    private CsPhysicsInventoryTotalMapper csPhysicsInventoryTotalMapper;
    @Resource
    private CsPhysicsWarehouseMapper csPhysicsWarehouseMapper;
    @Resource
    private ICsOutResultOrderQueryService csOutResultOrderQueryService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private RepeatFilter repeatFilter;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsOutResultOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u51fa\u5e93\u7ed3\u679c\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.repeatFilter.checkRepeat("OutResult:" + addReqDto.getPreOrderNo(), () -> this.preValid(addReqDto), true);
        this.dataValid(addReqDto);
        CsOutResultOrderEo outResultOrderEo = new CsOutResultOrderEo();
        CubeBeanUtils.copyProperties((Object)outResultOrderEo, (Object)addReqDto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.generateCode("402");
        String documentNo = generateCodeEnum.getCode();
        String orderStatus = generateCodeEnum.getStatus();
        outResultOrderEo.setDocumentNo(documentNo);
        outResultOrderEo.setOrderStatus(orderStatus);
        outResultOrderEo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        this.csOutResultOrderMapper.insert((Object)outResultOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsOutResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CsOutResultOrderDetailEo detailEo = new CsOutResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(documentNo);
            detailEoList.add(detailEo);
        }
        this.csOutResultOrderDetailMapper.insertBatch((List)detailEoList);
        return outResultOrderEo.getId();
    }

    private void preValid(CsOutResultOrderAddReqDto addReqDto) {
        List oldList = this.csOutResultOrderMapper.queryByRelevanceNo(addReqDto.getRelevanceNo());
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (CsOutResultOrderEo csOutResultOrderEo : oldList) {
                AssertUtil.isTrue(CsOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(csOutResultOrderEo.getOrderStatus()), CsInventoryExceptionCode.SUCCESS_CODE.getCode(), CsInventoryExceptionCode.SUCCESS_CODE.getMsg());
            }
        }
    }

    private void dataValid(CsOutResultOrderAddReqDto addReqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getPreOrderNo()), "\u672a\u4f20\u5165\u524d\u7f6e\u4e1a\u52a1\u5355\u636e");
        AssertUtil.isTrue(addReqDto.getBusinessType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)BusinessTypeEnum.getDescByCode((String)addReqDto.getBusinessType())), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        List csOutNoticeOrderEos = this.csOutNoticeOrderMapper.queryByPreOrderNo(addReqDto.getPreOrderNo());
        if (BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_ISSUE.getCode().equals(addReqDto.getBusinessType())) {
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderEos), "\u524d\u7f6e\u5355\u636e\u4e0d\u5b58\u5728");
            addReqDto.setExternalOrderNo(((CsOutNoticeOrderEo)csOutNoticeOrderEos.get(0)).getExternalOrderNo());
            addReqDto.setRelevanceNo(((CsOutNoticeOrderEo)csOutNoticeOrderEos.get(0)).getDocumentNo());
        }
        List physicsWarehouseEos = this.csPhysicsWarehouseMapper.queryByWarehouseCode(addReqDto.getWarehouseCode());
        List cargoList = addReqDto.getDetailAddReqDtoList().stream().map(CsOutResultOrderDetailAddReqDto::getCargoCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)physicsWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(cargoList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"warehouse_code", (Object)addReqDto.getWarehouseCode());
        wrapper.in((Object)"cargo_code", cargoList);
        wrapper.eq((Object)"dr", (Object)0);
        List physicsInventoryTotalEoList = this.csPhysicsInventoryTotalMapper.selectList((Wrapper)wrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)physicsInventoryTotalEoList), "\u8d27\u54c1\u5e93\u5b58\u672a\u914d\u7f6e");
        if (physicsInventoryTotalEoList.size() != cargoList.size()) {
            logger.info("error,\u5e93\u5b58\u8d27\u54c1\u4e0d\u4e00\u81f4\uff1b");
            HashMap<String, String> inventoryMap = new HashMap<String, String>();
            for (CsPhysicsInventoryTotalEo physicsInventoryTotalEo : physicsInventoryTotalEoList) {
                inventoryMap.put(physicsInventoryTotalEo.getWarehouseCode() + physicsInventoryTotalEo.getCargoCode(), physicsInventoryTotalEo.getCargoName());
            }
            for (CsOutResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
                if (!StringUtils.isEmpty((CharSequence)((CharSequence)inventoryMap.get(addReqDto.getWarehouseCode() + detailAddReqDto.getCargoCode())))) continue;
                String ex = "\u8d27\u54c1\u5e93\u5b58\u672a\u914d\u7f6e\uff0c\u4ed3\u5e93\uff1a[" + addReqDto.getWarehouseCode() + "]\u8d27\u54c1\u7f16\u7801\uff1a[" + detailAddReqDto.getCargoCode() + "]\u6279\u6b21\uff1a[" + detailAddReqDto.getBatch() + "]";
                throw new CsInventoryException(CsInventoryExceptionCode.INVENTORY_EXCEPTION.getCode(), ex);
            }
        }
        CsPhysicsWarehouseEo csPhysicsWarehouseEo = (CsPhysicsWarehouseEo)physicsWarehouseEos.get(0);
        addReqDto.setWarehouseId(csPhysicsWarehouseEo.getId());
        addReqDto.setWarehouseName(csPhysicsWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        Map<String, CsPhysicsInventoryTotalEo> cargoMap = physicsInventoryTotalEoList.stream().collect(Collectors.toMap(CsPhysicsInventoryTotalEo::getCargoCode, entity -> entity));
        for (CsOutResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            CsPhysicsInventoryTotalEo physicsInventoryTotalEo = cargoMap.get(detailAddReqDto.getCargoCode());
            if (null == physicsInventoryTotalEo) {
                logger.info("error,\u8ba2\u5355\u5546\u54c1\u5e93\u5b58\u4e0d\u5b58\u5728\uff0c\u540e\u7eed\u5904\u7406");
                continue;
            }
            detailAddReqDto.setCargoId(physicsInventoryTotalEo.getCargoId());
            detailAddReqDto.setCargoName(physicsInventoryTotalEo.getCargoName());
        }
    }

    @Override
    public void update(Long id, CsOutResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsOutResultOrderEo updateEo = CsOutResultOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csOutResultOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsOutResultOrderEo eo = this.csOutResultOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csOutResultOrderDas.logicDeleteById(id);
    }
}

