/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.order;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.enus.OrderTypeEnu;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjAdjustService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjBaseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.constant.AdjustActionEnum;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.CargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjCargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderCargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjResDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatus;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustAuReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustUpReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.resp.TcbjAdjustDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.resp.TcbjAdjustRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TcbjAdjustServiceImpl
implements ITcbjAdjustService {
    private static final Logger logger = LoggerFactory.getLogger(TcbjAdjustServiceImpl.class);
    @Autowired
    private TcbjDRAOrderMapper tcbjDRAOrderMapper;
    @Autowired
    private TcbjDRAOrderCargoMapper tcbjDRAOrderCargoMapper;
    @Autowired
    private ITcbjBaseService tcbjBaseService;
    @Autowired
    private TcbjCargoMapper tcbjCargoMapper;
    @Autowired
    private CargoMapper cargoMapper;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;

    @Override
    public RestResponse<PageInfo<TcbjAdjustRespDto>> page(TcbjAdjustReqDto queryDto) {
        logger.info("\u83b7\u53d6\u8c03\u6574\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum() == null ? 1 : queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize() == null ? 10 : queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"category", (Object)"301");
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        wrapper.eq((Object)"organization_id", (Object)orgId);
        if (ObjectUtil.isNotEmpty((Object)queryDto.getNo())) {
            wrapper.eq((Object)"no", (Object)queryDto.getNo());
        }
        if (ObjectUtil.isNotEmpty((Object)queryDto.getWarehouseCode())) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (ObjectUtil.isNotEmpty((Object)queryDto.getWarehouseName())) {
            wrapper.eq((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (ObjectUtil.isNotEmpty((Object)queryDto.getStatus())) {
            wrapper.eq((Object)"status", (Object)queryDto.getStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)queryDto.getCreatTimeStart())) {
            wrapper.ge((Object)"create_time", (Object)queryDto.getCreatTimeStart());
        }
        if (ObjectUtil.isNotEmpty((Object)queryDto.getCreatTimeEnd())) {
            wrapper.le((Object)"create_time", (Object)queryDto.getCreatTimeEnd());
        }
        wrapper.orderByDesc((Object)"create_time");
        List list = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper);
        PageInfo info = new PageInfo(list);
        List rList = list.stream().map(t -> {
            TcbjAdjustRespDto dto = new TcbjAdjustRespDto();
            try {
                BeanUtils.copyProperties((Object)t, (Object)dto);
                dto.setId(t.getId() + "");
                dto.setWarehouseId(t.getWarehouseId() + "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return dto;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo(rList);
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(rList);
        logger.info("\u83b7\u53d6\u8c03\u6574\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
        return new RestResponse("0", "success", (Object)result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> gen(TcbjAdjustGenReqDto reqDto) {
        logger.info("\u83b7\u53d6\u8c03\u6574\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.assertNotEmpty(reqDto.getCargos(), "\u5546\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        DRAOrderEo draOrderEo = new DRAOrderEo();
        draOrderEo.setCategory("301");
        draOrderEo.setWarehouseCode(reqDto.getWarehouseCode());
        draOrderEo.setWarepos(reqDto.getWarepos());
        draOrderEo.setRemark(reqDto.getRemark());
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        draOrderEo.setOrganizationId(orgId);
        this.tcbjBaseService.add(draOrderEo);
        logger.info("\u83b7\u53d6\u8c03\u6574\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)draOrderEo));
        this.insertBatchCargos(reqDto.getCargos(), draOrderEo);
        return RestResponse.SUCCEED;
    }

    private void insertBatchCargos(List<TcbjAdjustItemReqDto> reqDtos, DRAOrderEo order) {
        List cargoIds = reqDtos.stream().map(TcbjAdjustItemReqDto::getCargoId).collect(Collectors.toList());
        UpdateWrapper queryEo = new UpdateWrapper();
        queryEo.in((Object)"id", cargoIds);
        List cargoEos = this.cargoMapper.selectList((Wrapper)queryEo);
        Map<Long, CargoEo> cargoEoMap = cargoEos.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        List list = reqDtos.stream().map(e -> this.buildCargoEo((TcbjAdjustItemReqDto)e, cargoEoMap, order)).collect(Collectors.toList());
        this.tcbjDRAOrderCargoMapper.insertBatch(list);
    }

    private DRAOrderCargoEo buildCargoEo(TcbjAdjustItemReqDto cargo, Map<Long, CargoEo> cargoEoMap, DRAOrderEo order) {
        DRAOrderCargoEo draOrderCargoEo = new DRAOrderCargoEo();
        CargoEo cargoEo = cargoEoMap.get(cargo.getCargoId());
        AssertUtil.isTrue(null != cargoEo, "\u5546\u54c1\u4fe1\u606f\u672a\u627e\u5230");
        draOrderCargoEo.setCargoName(cargoEo.getName());
        draOrderCargoEo.setCargoCode(cargoEo.getCode());
        draOrderCargoEo.setCargoNo(cargoEo.getArtNo());
        draOrderCargoEo.setCargoId(cargoEo.getId());
        draOrderCargoEo.setOrderNo(order.getNo());
        draOrderCargoEo.setOrderId(order.getId());
        draOrderCargoEo.setNum(cargo.getNum());
        draOrderCargoEo.setBatch(cargo.getBatch());
        draOrderCargoEo.setCreateTime(new Date(new Date().getTime()));
        draOrderCargoEo.setDr(0);
        if (AdjustActionEnum.INCR.getCode() == cargo.getAction().intValue()) {
            throw new BizException("-1", "\u5e93\u5b58\u8c03\u6574\u53ea\u5141\u8bb8\u51cf\u5c11");
        }
        draOrderCargoEo.setRemark(AdjustActionEnum.DECR.getDesc());
        return draOrderCargoEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> update(TcbjAdjustUpReqDto reqDto) {
        logger.info("\u83b7\u53d6\u8c03\u6574\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.assertNotEmpty(reqDto.getCargos(), "\u5546\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        DRAOrderEo orderEo = new DRAOrderEo();
        orderEo.setId(reqDto.getId());
        DRAOrderEo draOrderEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectById((Serializable)orderEo);
        if (draOrderEo == null) {
            throw new BizException("\u4e0d\u5b58\u5728\u6b64\u8c03\u6574\u5355");
        }
        if (draOrderEo.getStatus().intValue() == OrderStatusEnum.ADJUST_FINISH.getCode().intValue()) {
            throw new BizException("\u8be5\u8c03\u6574\u5355\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        BeanUtils.copyProperties((Object)draOrderEo, (Object)orderEo);
        orderEo.setWarehouseCode(reqDto.getWarehouseCode());
        orderEo.setWarepos(reqDto.getWarepos());
        orderEo.setRemark(reqDto.getRemark());
        if (draOrderEo.getStatus().intValue() == OrderStatusEnum.ADJUST_REFUSE.getCode().intValue()) {
            orderEo.setStatus(OrderStatusEnum.ADJUST_WAIT_AUDIT.getCode());
        }
        this.tcbjDRAOrderMapper.updateById((BaseEo)orderEo);
        AssertUtil.assertNotBlank(orderEo.getNo(), "\u5355\u636e\u53f7\u4e3a\u7a7a");
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"order_no", (Object)orderEo.getNo());
        DRAOrderCargoEo drUpdateEo = new DRAOrderCargoEo();
        drUpdateEo.setDr(1);
        this.tcbjDRAOrderCargoMapper.update((Object)drUpdateEo, (Wrapper)updateWrapper);
        this.insertBatchCargos(reqDto.getCargos(), orderEo);
        logger.info("\u83b7\u53d6\u8c03\u6574\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)orderEo));
        return RestResponse.SUCCEED;
    }

    @Override
    public RestResponse<TcbjAdjustDetailRespDto> detail(String id) {
        logger.info("\u83b7\u53d6\u8c03\u6574\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)id));
        DRAOrderEo orderEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectById((Serializable)((Object)id));
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.eq((Object)"order_no", (Object)orderEo.getNo());
        qwrapper.eq((Object)"dr", (Object)"0");
        List selectList = this.tcbjDRAOrderCargoMapper.selectList((Wrapper)qwrapper);
        List cargos = selectList.stream().map(c -> {
            TcbjResDetailCargoRespDto tmp = new TcbjResDetailCargoRespDto();
            try {
                BeanUtils.copyProperties((Object)c, (Object)tmp);
                tmp.setCargoId(c.getCargoId() + "");
                if (AdjustActionEnum.DECR.getDesc().equals(c.getRemark())) {
                    tmp.setAction(Integer.valueOf(AdjustActionEnum.DECR.getCode()));
                } else {
                    tmp.setAction(Integer.valueOf(AdjustActionEnum.INCR.getCode()));
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u8c03\u6574\u5355-\u51fa\u9519:{}", (Object)e.toString());
            }
            return tmp;
        }).collect(Collectors.toList());
        TcbjAdjustDetailRespDto dto = new TcbjAdjustDetailRespDto();
        try {
            BeanUtils.copyProperties((Object)orderEo, (Object)dto);
            dto.setCargos(cargos);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8c03\u6574\u5355-\u51fa\u9519:{}", (Object)e.toString());
        }
        logger.info("\u83b7\u53d6\u8c03\u6574\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)dto));
        return new RestResponse("0", "success", (Object)dto);
    }

    @Override
    public RestResponse<String> addCargo(TcbjAdjustItemReqDto dto) {
        logger.info("\u83b7\u53d6\u8c03\u6574\u5355\u5546\u54c1-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)dto));
        return RestResponse.SUCCEED;
    }

    @Override
    public RestResponse<String> delCargo(TcbjAdjustItemReqDto dto) {
        logger.info("\u83b7\u53d6\u8c03\u6574\u5355\u5546\u54c1-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)dto));
        return RestResponse.SUCCEED;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> audit(TcbjAdjustAuReqDto dto) {
        HashMap orderMap = Maps.newHashMap();
        HashMap orderCargoMap = Maps.newHashMap();
        for (String id : dto.getIds()) {
            DRAOrderEo draOrderEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectById((Serializable)((Object)id));
            if (dto.getStatus().equals("Y")) {
                draOrderEo.setStatus(OrderStatus.ADJUST_FINISH);
            } else {
                draOrderEo.setStatus(OrderStatus.ADJUST_REFUSE);
            }
            draOrderEo.setAuditPerson(this.context.userName());
            draOrderEo.setAuditTime(new Date());
            this.tcbjDRAOrderMapper.updateById((BaseEo)draOrderEo);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"order_no", (Object)draOrderEo.getNo());
            wrapper.eq((Object)"dr", (Object)0);
            List draOrderCargoEos = this.tcbjDRAOrderCargoMapper.selectList((Wrapper)wrapper);
            draOrderEo.setType(Integer.valueOf(OrderTypeEnu.INVOKE_CUBE_ORDER_MATERIAL_ADJUST_OUT.getCode()));
            orderMap.put(id, draOrderEo);
            orderCargoMap.put(id, draOrderCargoEos);
        }
        orderMap.forEach((k, v) -> {
            if (v.getStatus().equals(OrderStatus.ADJUST_FINISH)) {
                this.tcbjBaseService.physicWarehouseAdjustInOut((DRAOrderEo)v, (List)orderCargoMap.get(k), 1);
            }
        });
        return RestResponse.SUCCEED;
    }
}

