/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.RepeatFilter;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.in.CsInNoticeOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInNoticeOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInNoticeOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsRelWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInNoticeOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInNoticeOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsReceiveNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsReceiveNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInNoticeOrderService")
public class CsInNoticeOrderServiceImpl
implements ICsInNoticeOrderService {
    private static Logger logger = LoggerFactory.getLogger(CsInNoticeOrderServiceImpl.class);
    @Autowired
    private CsInNoticeOrderDas csInNoticeOrderDas;
    @Autowired
    private ICsInNoticeOrderQueryService csInNoticeOrderQueryService;
    @Resource
    private CsInNoticeOrderMapper csInNoticeOrderMapper;
    @Resource
    private CsInNoticeOrderDetailMapper csInNoticeOrderDetailMapper;
    @Resource
    private ICsReceiveNoticeOrderQueryService csReceiveNoticeOrderQueryService;
    @Resource
    private ICsRelWarehouseQueryService csRelWarehouseQueryService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private RepeatFilter repeatFilter;

    @Override
    public Long add(CsInNoticeOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInNoticeOrderEo insertEo = CsInNoticeOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csInNoticeOrderDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsInNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInNoticeOrderEo updateEo = CsInNoticeOrderEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csInNoticeOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsInNoticeOrderEo eo = this.csInNoticeOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csInNoticeOrderDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createInNoticeOrder(String relevanceNo) {
        logger.info("\u6839\u636e\u6536\u8d27\u901a\u77e5\u5355\u53f7\uff0c\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\uff1a[relevanceNo:{}]", (Object)relevanceNo);
        this.repeatFilter.checkRepeat("InNotice:" + relevanceNo, () -> this.preValid(relevanceNo), true);
        CsReceiveNoticeOrderRespDto dto = this.csReceiveNoticeOrderQueryService.queryByDocumentNo(relevanceNo);
        List<CsRelWarehouseEo> csRelWarehouseEos = this.csRelWarehouseQueryService.queryByRefWarehouseCode(dto.getWarehouseCode(), dto.getWarehouseClassify());
        for (CsRelWarehouseEo relWarehouseEo : csRelWarehouseEos) {
            if (!CsWarehouseClassifyEnum.PHYSICS.getCode().equals(relWarehouseEo.getWarehouseClassify())) continue;
            dto.setWarehouseId(relWarehouseEo.getWarehouseId());
            dto.setWarehouseCode(relWarehouseEo.getWarehouseCode());
            dto.setWarehouseName(relWarehouseEo.getWarehouseName());
        }
        CsInNoticeOrderEo csInNoticeOrderEo = new CsInNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)csInNoticeOrderEo, (Object)dto, (String[])new String[]{"id"});
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.generateCode("501");
        String documentNo = generateCodeEnum.getCode();
        String orderStatus = generateCodeEnum.getStatus();
        csInNoticeOrderEo.setDocumentNo(documentNo);
        csInNoticeOrderEo.setOrderStatus(orderStatus);
        csInNoticeOrderEo.setRelevanceNo(relevanceNo);
        csInNoticeOrderEo.setExternalOrderNo(dto.getExternalOrderNo());
        csInNoticeOrderEo.setExtension(JSON.toJSONString((Object)dto.getContactDto()));
        this.csInNoticeOrderMapper.insert((Object)csInNoticeOrderEo);
        if (CollectionUtils.isNotEmpty((Collection)dto.getReceiveNoticeOrderDetailRespDtoList())) {
            ArrayList detailEoList = Lists.newArrayList();
            for (CsReceiveNoticeOrderDetailRespDto detailRespDto : dto.getReceiveNoticeOrderDetailRespDtoList()) {
                CsInNoticeOrderDetailEo detailEo = new CsInNoticeOrderDetailEo();
                CubeBeanUtils.copyProperties((Object)detailEo, (Object)dto, (String[])new String[]{"id"});
                CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailRespDto, (String[])new String[]{"id"});
                detailEo.setDocumentNo(documentNo);
                detailEo.setRelevanceNo(relevanceNo);
                detailEoList.add(detailEo);
            }
            this.csInNoticeOrderDetailMapper.insertBatch((List)detailEoList);
        }
        logger.info("\u6839\u636e\u6536\u8d27\u901a\u77e5\u5355\u53f7\uff0c\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\uff0c\u7ed3\u679c\uff1a[id:{}]", (Object)csInNoticeOrderEo.getId());
        return csInNoticeOrderEo.getId();
    }

    private void preValid(String relevanceNo) {
        List oldList = this.csInNoticeOrderMapper.queryByRelevanceNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (CsInNoticeOrderEo noticeOrderEo : oldList) {
                AssertUtil.isTrue(CsOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(noticeOrderEo.getOrderStatus()), "304", noticeOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }
}

