/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.AbstractCsInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryBasicsOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsActivityInventoryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.log.CsActivityInventoryLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsActivityInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.log.CsActivityInventoryLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsActivityInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsActivityInventoryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="CsactivityinventoryStrategyService")
public class CsActivityInventoryServiceImpl
extends AbstractCsInventoryService {
    private Logger logger = LoggerFactory.getLogger(CsActivityInventoryServiceImpl.class);
    @Autowired
    private CsActivityInventoryDas csActivityInventoryDas;
    @Autowired
    private CsActivityInventoryLogDas csActivityInventoryLogDas;
    @Autowired
    private CsActivityInventoryMapper csActivityInventoryMapper;
    @Autowired
    private IContext context;
    @Autowired
    @Qualifier(value="CsactivityinventoryStrategyService")
    private ICsInventoryBasicsOperateService activityBasicsOperateService;

    @Override
    public String getStrategy() {
        return CsInventoryStrategyEnum.ACTIVITY.getCode();
    }

    @Override
    protected void doPreProcessor(CsInventoryInOutBasicsDto inParamDto) {
        List inOutBasicsCargoDtoList = inParamDto.getInOutBasicsCargoDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)inOutBasicsCargoDtoList), "\u8d27\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Map<Long, List<CsInventoryInOutBasicsCargoDto>> csActDtoMap = inOutBasicsCargoDtoList.stream().collect(Collectors.groupingBy(CsInventoryInOutBasicsCargoDto::getActivityId));
        Set<Map.Entry<Long, List<CsInventoryInOutBasicsCargoDto>>> entrySet = csActDtoMap.entrySet();
        for (Map.Entry<Long, List<CsInventoryInOutBasicsCargoDto>> entry : entrySet) {
            List<CsInventoryInOutBasicsCargoDto> basicsCargoDtoList = entry.getValue();
            if (CollectionUtils.isEmpty(basicsCargoDtoList)) continue;
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = basicsCargoDtoList.get(0);
            this.buildInfo(inParamDto, inOutBasicsCargoDto, basicsCargoDtoList);
        }
    }

    private void buildInfo(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto, List<CsInventoryInOutBasicsCargoDto> basicsCargoDtoList) {
        Long activityId = inOutBasicsCargoDto.getActivityId();
        this.logger.info("doPreProcessor==>\u6d3b\u52a8\u5e93\u5b58\u7b56\u7565,\u5e93\u5b58\u524d\u7f6e\u5904\u7406\u65b9\u6cd5,activityId:{}", (Object)activityId);
        String sourceType = inParamDto.getSourceType();
        if (CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode().equals(sourceType)) {
            sourceType = CsInventorySourceTypeEnum.OUT_ACT_ORDER_PREEMPT.getCode();
            inParamDto.setSourceType(sourceType);
        }
        if (CsInventorySourceTypeEnum.IN_SALE_RELEASE.getCode().equals(sourceType)) {
            sourceType = CsInventorySourceTypeEnum.IN_ACT_CANCEL_PREEMPT.getCode();
            inParamDto.setSourceType(sourceType);
        }
        CsActivityInventoryEo csActivityInventoryEo = new CsActivityInventoryEo();
        if (CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT.getCode().equals(sourceType)) {
            CubeBeanUtils.copyProperties((Object)csActivityInventoryEo, (Object)inOutBasicsCargoDto, (String[])new String[0]);
        } else {
            CsActivityInventoryEo queryEo = new CsActivityInventoryEo();
            queryEo.setActivityId(activityId);
            List csActivityInventoryEoList = this.csActivityInventoryDas.selectList((BaseEo)queryEo);
            this.logger.info("doPreProcessor==>ACT,csActivityInventoryEoList:{}", (Object)LogUtils.buildLogContent(csActivityInventoryEoList));
            if (CollectionUtils.isEmpty((Collection)csActivityInventoryEoList)) {
                return;
            }
            csActivityInventoryEo = (CsActivityInventoryEo)csActivityInventoryEoList.get(0);
        }
        for (CsInventoryInOutBasicsCargoDto basicsCargoDto : basicsCargoDtoList) {
            basicsCargoDto.setActivityId(csActivityInventoryEo.getActivityId());
            basicsCargoDto.setActivityName(csActivityInventoryEo.getActivityName());
            basicsCargoDto.setActivityCode(csActivityInventoryEo.getActivityCode());
            basicsCargoDto.setWarehouseId(csActivityInventoryEo.getWarehouseId());
            basicsCargoDto.setWarehouseName(csActivityInventoryEo.getWarehouseName());
            basicsCargoDto.setWarehouseCode(csActivityInventoryEo.getWarehouseCode());
            basicsCargoDto.setActivityNum(csActivityInventoryEo.getActivityNum());
            basicsCargoDto.setSuitCode(csActivityInventoryEo.getSuitCode());
            basicsCargoDto.setSuitName(csActivityInventoryEo.getSuitName());
            basicsCargoDto.setShopId(csActivityInventoryEo.getShopId());
            basicsCargoDto.setShopCode(csActivityInventoryEo.getShopCode());
            basicsCargoDto.setShopName(csActivityInventoryEo.getShopName());
            basicsCargoDto.setActivityFlag(YesNoEnum.YES.getValue());
        }
        inParamDto.setNegativeValidate(YesNoEnum.YES.getValue());
    }

    @Override
    protected Boolean doInsertInventoryLog(CsInventoryInOutBasicsDto inOutBasicDto, CsInventoryInOutBasicsCargoDto basicDetailDto) {
        CsActivityInventoryLogEo csActivityInventoryLogEo = new CsActivityInventoryLogEo();
        csActivityInventoryLogEo.setId(IdUtils.getId());
        csActivityInventoryLogEo.setWarehouseId(basicDetailDto.getWarehouseId());
        csActivityInventoryLogEo.setWarehouseCode(basicDetailDto.getWarehouseCode());
        csActivityInventoryLogEo.setWarehouseName(basicDetailDto.getWarehouseName());
        csActivityInventoryLogEo.setShopId(basicDetailDto.getShopId());
        csActivityInventoryLogEo.setShopCode(basicDetailDto.getShopCode());
        csActivityInventoryLogEo.setShopName(basicDetailDto.getShopName());
        csActivityInventoryLogEo.setCargoId(basicDetailDto.getCargoId());
        csActivityInventoryLogEo.setCargoCode(basicDetailDto.getCargoCode());
        csActivityInventoryLogEo.setCargoName(basicDetailDto.getCargoName());
        csActivityInventoryLogEo.setSuitCode(basicDetailDto.getSuitCode());
        csActivityInventoryLogEo.setSuitName(basicDetailDto.getSuitName());
        csActivityInventoryLogEo.setActivityType(basicDetailDto.getActivityType());
        csActivityInventoryLogEo.setActivityCode(basicDetailDto.getActivityCode());
        csActivityInventoryLogEo.setActivityName(basicDetailDto.getActivityName());
        csActivityInventoryLogEo.setArtNo(basicDetailDto.getArtNo());
        csActivityInventoryLogEo.setActivityNum(basicDetailDto.getActivityNum());
        csActivityInventoryLogEo.setBatch(basicDetailDto.getBatch());
        csActivityInventoryLogEo.setChangeBalance(basicDetailDto.getBalance());
        csActivityInventoryLogEo.setChangePreempt(basicDetailDto.getPreempt());
        csActivityInventoryLogEo.setChangeCompleted(basicDetailDto.getCompleted());
        csActivityInventoryLogEo.setIsGift(basicDetailDto.getIsGift());
        csActivityInventoryLogEo.setChangeAvailable(this.calculateChangeAvailableInventory(inOutBasicDto, basicDetailDto));
        csActivityInventoryLogEo.setUpdateTime(new Date());
        csActivityInventoryLogEo.setCreateTime(new Date());
        csActivityInventoryLogEo.setChangeTime(csActivityInventoryLogEo.getCreateTime());
        csActivityInventoryLogEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        csActivityInventoryLogEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        csActivityInventoryLogEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        csActivityInventoryLogEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        csActivityInventoryLogEo.setSourceNo(inOutBasicDto.getSourceNo());
        csActivityInventoryLogEo.setSourceType(inOutBasicDto.getSourceType());
        csActivityInventoryLogEo.setActivityId(basicDetailDto.getActivityId());
        csActivityInventoryLogEo.setInOutFlag(inOutBasicDto.getInOutFlag());
        this.logger.info("doInsertInventoryLog==>\u6d3b\u52a8\u5e93\u5b58\u7b56\u7565,\u5373\u5c06\u63d2\u5165\u5e93\u5b58\u6d41\u6c34,sourceNo:{},csInventoryLogEo:{}", (Object)inOutBasicDto.getSourceNo(), (Object)LogUtils.buildLogContent(csActivityInventoryLogEo));
        int result = 0;
        if (CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT.getCode().equals(inOutBasicDto.getSourceType())) {
            csActivityInventoryLogEo.setBeforeBalance(BigDecimal.ZERO);
            csActivityInventoryLogEo.setChangeBalance(basicDetailDto.getBalance());
            csActivityInventoryLogEo.setAfterBalance(basicDetailDto.getBalance());
            csActivityInventoryLogEo.setBeforeAvailable(BigDecimal.ZERO);
            csActivityInventoryLogEo.setChangeAvailable(basicDetailDto.getBalance());
            csActivityInventoryLogEo.setAfterAvailable(basicDetailDto.getBalance());
            csActivityInventoryLogEo.setBeforePreempt(BigDecimal.ZERO);
            csActivityInventoryLogEo.setChangePreempt(BigDecimal.ZERO);
            csActivityInventoryLogEo.setAfterPreempt(BigDecimal.ZERO);
            csActivityInventoryLogEo.setBeforeCompleted(BigDecimal.ZERO);
            csActivityInventoryLogEo.setChangeCompleted(BigDecimal.ZERO);
            csActivityInventoryLogEo.setAfterCompleted(BigDecimal.ZERO);
            result = this.csActivityInventoryLogDas.insert((BaseEo)csActivityInventoryLogEo);
        } else {
            result = this.csActivityInventoryLogDas.insertLog(csActivityInventoryLogEo);
        }
        return result > 0;
    }

    @Override
    protected String inventoryLockKey(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)batch), "\u6d3b\u52a8\u5546\u54c1\u5fc5\u987b\u5305\u542b\u6279\u6b21");
        return String.format("%s_%s_%s_%s", inDetailDto.getActivityId(), inDetailDto.getWarehouseId(), inDetailDto.getCargoId(), inDetailDto.getBatch());
    }

    @Override
    public Long existInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        String batch = inDetailDto.getBatch();
        Long activityId = inDetailDto.getActivityId();
        String warehouseCode = inDetailDto.getWarehouseCode();
        String cargoCode = inDetailDto.getCargoCode();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"activity_id", (Object)activityId);
        wrapper.eq((Object)"batch", (Object)batch);
        wrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        wrapper.eq((Object)"cargo_code", (Object)cargoCode);
        CsActivityInventoryEo csActivityInventoryEo = (CsActivityInventoryEo)this.csActivityInventoryMapper.selectOne((Wrapper)wrapper);
        if (null == csActivityInventoryEo) {
            return null;
        }
        inDetailDto.setIsGift(csActivityInventoryEo.getIsGift());
        return csActivityInventoryEo.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean doInitInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        Mutex mutex = null;
        try {
            mutex = this.lock(inParamDto, inDetailDto);
            Boolean bl = this.activityBasicsOperateService.initInventory(inParamDto, inDetailDto);
            return bl;
        }
        finally {
            this.unLock(mutex);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean initInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        this.logger.info("activity,initInventory==>\u5373\u5c06\u6267\u884c\u521d\u59cb\u5316\u5e93\u5b58\u64cd\u4f5c,inParamDto:{},inDetailDto:{}", (Object)LogUtils.buildLogContent(inParamDto), (Object)LogUtils.buildLogContent(inDetailDto));
        if (null != this.existInventory(inParamDto, inDetailDto)) {
            return true;
        }
        return this.executeInitInventory(inParamDto, inDetailDto);
    }

    private Boolean executeInitInventory(CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        AssertUtil.isTrue(inDetailDto.getBalance().compareTo(BigDecimal.valueOf(0L)) >= 0, CsInventoryExceptionCode.INVENTORY_IS_NEGATIVE.getCode(), CsInventoryExceptionCode.INVENTORY_IS_NEGATIVE.getMsg());
        CsActivityInventoryEo inventoryEo = new CsActivityInventoryEo();
        CubeBeanUtils.copyProperties((Object)inventoryEo, (Object)inDetailDto, (String[])new String[0]);
        inventoryEo.setActivityName(inDetailDto.getActivityName());
        inventoryEo.setActivityCode(inDetailDto.getActivityCode());
        inventoryEo.setSuitCode(inDetailDto.getSuitCode());
        inventoryEo.setSuitName(inDetailDto.getSuitName());
        inventoryEo.setFinishFlag(inDetailDto.getFinishFlag());
        inventoryEo.setIsGift(inDetailDto.getIsGift());
        this.logger.info("doInitInventory==>ACT,\u521d\u59cb\u5316\u5e93\u5b58\u8bb0\u5f55,inventoryEo:{}", (Object)LogUtils.buildLogContent(inventoryEo));
        inventoryEo.setUpdateTime(new Date());
        inventoryEo.setCreateTime(new Date());
        inventoryEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        inventoryEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        inventoryEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        inventoryEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        int result = this.csActivityInventoryDas.insert((BaseEo)inventoryEo);
        return result > 0;
    }

    @Override
    public boolean doUpdateInventory(Long inventoryId, CsInventoryInOutBasicsDto inParamDto, CsInventoryInOutBasicsCargoDto inDetailDto) {
        this.logger.info("doUpdateInventory==>Act,inventoryId:{}", (Object)inventoryId);
        CsActivityInventoryEo csActivityInventoryEo = this.csActivityInventoryDas.selectByPrimaryKey(inventoryId);
        AssertUtil.isTrue(null != csActivityInventoryEo, "\u67e5\u8be2\u4e0d\u5230\u6d3b\u52a8\u4fe1\u606f");
        String finishFlag = csActivityInventoryEo.getFinishFlag();
        if (CsInventorySourceTypeEnum.OUT_ACT_ORDER_PREEMPT.getCode().equals(inParamDto.getSourceType()) || CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode().equals(inParamDto.getSourceType())) {
            AssertUtil.isTrue(CsActivityInventoryStatusEnum.ONGOING.getCode().equals(finishFlag), "\u6d3b\u52a8\u975e\u8fdb\u884c\u4e2d");
        }
        CsActivityInventoryEo updateEo = new CsActivityInventoryEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)inDetailDto, (String[])new String[0]);
        updateEo.setId(inventoryId);
        updateEo.setUpdateTime(new Date());
        updateEo.setCreateTime(new Date());
        updateEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        updateEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        updateEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        updateEo.setNegativeValidate(inParamDto.getNegativeValidate());
        int updateResult = this.csActivityInventoryDas.updateInventory(updateEo);
        return updateResult > 0;
    }
}

