/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogicInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLogicInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsLogicInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="csLogicInventoryQueryService")
public class CsLogicInventoryQueryServiceImpl
implements ICsLogicInventoryQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsLogicInventoryQueryServiceImpl.class);
    @Resource
    private CsLogicInventoryMapper csLogicInventoryMapper;

    @Override
    public CsLogicInventoryEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        return (CsLogicInventoryEo)this.csLogicInventoryMapper.selectById((Serializable)id);
    }

    @Override
    public PageInfo<CsLogicInventoryRespDto> queryByPage(CsLogicInventoryQueryDto queryDto) {
        logger.info("\u83b7\u53d6\u4ed3\u5e93\u5e93\u5b58-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)"0");
        if (queryDto.getWarehouseId() != null) {
            wrapper.eq((Object)"warehouse_id", (Object)queryDto.getWarehouseId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getWarehouseCode()})) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (queryDto.getCargoId() != null) {
            wrapper.eq((Object)"cargo_id", (Object)queryDto.getCargoId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoCode()})) {
            wrapper.like((Object)"cargo_code", (Object)queryDto.getCargoCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoName()})) {
            wrapper.like((Object)"cargo_name", (Object)("%" + queryDto.getCargoName() + "%"));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getArtNo()})) {
            wrapper.like((Object)"art_no", (Object)queryDto.getArtNo());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getBatch()})) {
            wrapper.like((Object)"batch", (Object)queryDto.getBatch());
        }
        wrapper.isNotNull((Object)"batch");
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List selectList = this.csLogicInventoryMapper.selectList((Wrapper)wrapper);
        PageInfo info = new PageInfo(selectList);
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)pageInfo, (String[])new String[]{"list"});
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)selectList, CsLogicInventoryRespDto.class);
        pageInfo.setList((List)list);
        logger.info("\u83b7\u53d6\u4ed3\u5e93\u5e93\u5b58-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)pageInfo));
        return pageInfo;
    }
}

