/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.api.annotion.Power;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ParseSubItemReq;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InventorySubItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInventorySubItemService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.CsInventoryStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryLogBasicsPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsActivityInventoryLogPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsInventoryLogPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsActivityInventoryLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsInventoryLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="csInventoryExposedQueryServiceImpl")
public class CsInventoryExposedQueryServiceImpl
implements ICsInventoryExposedQueryService {
    private Logger logger = LoggerFactory.getLogger(CsInventoryExposedQueryServiceImpl.class);
    @Resource
    private IInventorySubItemService inventorySubItemService;

    @Override
    public PageInfo<CsInventoryPageQueryRespDto> queryInventoryPage(CsInventoryPageQueryReqDto csInventoryPageQueryReqDto) {
        this.logger.info("queryInventoryPage==>\u5e93\u5b58\u5206\u9875\u67e5\u8be2,csInventoryPageQueryReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryPageQueryReqDto));
        if (StringUtils.isBlank((CharSequence)csInventoryPageQueryReqDto.getWarehouseClassify())) {
            csInventoryPageQueryReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        }
        this.checkParams(csInventoryPageQueryReqDto);
        String warehouseClassify = csInventoryPageQueryReqDto.getWarehouseClassify();
        CsInventoryStrategyEnum csInventoryStrategyEnum = CsInventoryStrategyEnum.getByCode((String)warehouseClassify);
        if (null == csInventoryStrategyEnum) {
            throw new BizException("\u5e93\u5b58\u7b56\u7565\u83b7\u53d6\u6709\u8bef~");
        }
        ICsInventoryQueryService inventoryQueryService = CsInventoryStrategyUtils.getInventoryQueryService(csInventoryStrategyEnum.getCode());
        this.logger.info("queryInventoryPage==>\u5e93\u5b58\u5206\u9875\u67e5\u8be2,inventoryQueryService:{}", (Object)LogUtils.buildLogContent(inventoryQueryService));
        CsInventoryBasicsPageQueryReqDto basicsPageQueryReqDto = new CsInventoryBasicsPageQueryReqDto();
        CubeBeanUtils.copyProperties((Object)basicsPageQueryReqDto, (Object)csInventoryPageQueryReqDto, (String[])new String[0]);
        PageInfo<CsInventoryBasicsPageQueryRespDto> pageInfo = inventoryQueryService.queryInventoryPage(basicsPageQueryReqDto);
        List pageInfoList = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)pageInfoList)) {
            return new PageInfo();
        }
        List respDtoList = pageInfoList.stream().map(e -> {
            CsInventoryPageQueryRespDto csInventoryPageQueryRespDto = new CsInventoryPageQueryRespDto();
            CubeBeanUtils.copyProperties((Object)csInventoryPageQueryRespDto, (Object)e, (String[])new String[0]);
            BigDecimal preempt = e.getPreempt() == null ? BigDecimal.ZERO : e.getPreempt();
            BigDecimal allocate = e.getAllocate() == null ? BigDecimal.ZERO : e.getAllocate();
            BigDecimal activityAllocate = e.getActivityAllocate() == null ? BigDecimal.ZERO : e.getActivityAllocate();
            BigDecimal transfer = e.getTransfer() == null ? BigDecimal.ZERO : e.getTransfer();
            BigDecimal totalPreempt = preempt.add(allocate).add(activityAllocate).add(transfer);
            csInventoryPageQueryRespDto.setPreempt(totalPreempt);
            return csInventoryPageQueryRespDto;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties(pageInfo, (Object)result);
        result.setList(respDtoList);
        return result;
    }

    @Override
    @Power
    public PageInfo<CsInventoryLogRespDto> queryInventoryLogPage(CsInventoryLogPageQueryReqDto csInventoryLogPageQueryReqDto) {
        this.logger.info("queryInventoryLogPage==>\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,csInventoryLogPageQueryReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryLogPageQueryReqDto));
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto.getPageNum() && csInventoryLogPageQueryReqDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto.getPageSize() && csInventoryLogPageQueryReqDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        ICsInventoryQueryService inventoryQueryService = CsInventoryStrategyUtils.getInventoryQueryService(CsInventoryStrategyEnum.COMMON.getCode());
        this.logger.info("queryInventoryLogPage==>\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,inventoryQueryService:{}", (Object)LogUtils.buildLogContent(inventoryQueryService));
        CsInventoryLogBasicsPageQueryReqDto logBasicsPageQueryReqDto = new CsInventoryLogBasicsPageQueryReqDto();
        CubeBeanUtils.copyProperties((Object)logBasicsPageQueryReqDto, (Object)csInventoryLogPageQueryReqDto, (String[])new String[0]);
        PageInfo<CsInventoryLogRespDto> csInventoryLogRespDtoPageInfo = inventoryQueryService.queryInventoryLogPage(logBasicsPageQueryReqDto);
        List pageInfoList = csInventoryLogRespDtoPageInfo.getList();
        ArrayList subItemReqs = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)subItemReqs, (Collection)pageInfoList, ParseSubItemReq.class);
        Map<String, List<InventorySubItemRespDto>> subItemRelation = Optional.of(this.inventorySubItemService.subItemRelation(subItemReqs)).orElse(Maps.newHashMap());
        if (!subItemRelation.isEmpty()) {
            pageInfoList.stream().forEach(c -> c.setSubItemList((List)subItemRelation.getOrDefault(c.getCargoCode() + c.getBatch(), Lists.newArrayList())));
        }
        if (CollectionUtils.isEmpty((Collection)pageInfoList)) {
            return new PageInfo();
        }
        return csInventoryLogRespDtoPageInfo;
    }

    @Override
    public PageInfo<CsActivityInventoryLogRespDto> queryActivityInventoryLogPage(CsActivityInventoryLogPageQueryReqDto csInventoryLogPageQueryReqDto) {
        this.logger.info("queryActivityInventoryLogPage==>\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,csInventoryLogPageQueryReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryLogPageQueryReqDto));
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto.getPageNum() && csInventoryLogPageQueryReqDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto.getPageSize() && csInventoryLogPageQueryReqDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        ICsInventoryQueryService inventoryQueryService = CsInventoryStrategyUtils.getInventoryQueryService(CsInventoryStrategyEnum.ACTIVITY.getCode());
        return inventoryQueryService.queryActivityInventoryLogPage(csInventoryLogPageQueryReqDto);
    }

    @Override
    public List<CsInventoryBasicsQueryRespDto> queryCommonInventory(CsInventoryBasicsQueryReqDto basicsQueryReqDto) {
        this.logger.info("queryCommonInventory==>\u5e93\u5b58\u901a\u7528\u67e5\u8be2\u63a5\u53e3,basicsQueryReqDto:{}", (Object)LogUtils.buildLogContent(basicsQueryReqDto));
        this.checkParams(basicsQueryReqDto);
        String inventoryStrategy = basicsQueryReqDto.getInventoryStrategy();
        ICsInventoryQueryService inventoryQueryService = CsInventoryStrategyUtils.getInventoryQueryService(inventoryStrategy);
        List<CsInventoryBasicsQueryRespDto> resultList = inventoryQueryService.queryCommonInventory(basicsQueryReqDto);
        return resultList;
    }

    private void checkParams(CsInventoryBasicsQueryReqDto basicsQueryReqDto) {
        AssertUtil.isTrue(null != basicsQueryReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)basicsQueryReqDto.getInventoryStrategy()) && null != CsInventoryStrategyEnum.getByCode((String)basicsQueryReqDto.getInventoryStrategy()), "\u64cd\u4f5c\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void checkParams(CsInventoryPageQueryReqDto csInventoryPageQueryReqDto) {
        AssertUtil.isTrue(null != csInventoryPageQueryReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csInventoryPageQueryReqDto.getPageNum() && csInventoryPageQueryReqDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csInventoryPageQueryReqDto.getPageSize() && csInventoryPageQueryReqDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        String warehouseClassify = csInventoryPageQueryReqDto.getWarehouseClassify();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseClassify) && null != CsWarehouseClassifyEnum.getByCode((String)warehouseClassify), "\u4ed3\u5e93\u5206\u7c7b\u53c2\u6570\u6709\u8bef");
    }
}

