/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.RepeatFilter;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsDeliveryNoticeOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsDeliveryResultOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsDeliveryResultOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryNoticeOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryResultOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryResultOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDocumentExpressReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutResultOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="csDeliveryResultOrderService")
public class CsDeliveryResultOrderServiceImpl
implements ICsDeliveryResultOrderService {
    private static Logger logger = LoggerFactory.getLogger(CsDeliveryResultOrderServiceImpl.class);
    @Resource
    private CsDeliveryResultOrderMapper csDeliveryResultOrderMapper;
    @Resource
    private CsDeliveryResultOrderDetailMapper csDeliveryResultOrderDetailMapper;
    @Resource
    private CsDeliveryNoticeOrderDetailMapper csDeliveryNoticeOrderDetailMapper;
    @Resource
    private ICsOutResultOrderQueryService csOutResultOrderQueryService;
    @Resource
    private ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private RepeatFilter repeatFilter;
    @Resource
    private CsCommonService csCommonService;

    @Override
    public Long add(CsDeliveryResultOrderAddReqDto addReqDto) {
        return null;
    }

    @Override
    public void update(Long id, CsDeliveryResultOrderUpdateReqDto updateReqDto) {
    }

    @Override
    public void delete(Long id) {
    }

    @Override
    public void updateExpressInfo(CsDocumentExpressReqDto reqDto) {
        List list = this.csDeliveryResultOrderMapper.queryByDocumentNo(reqDto.getDocumentNo());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u636e\u4e0d\u5b58\u5728");
        CsDeliveryResultOrderEo eo = new CsDeliveryResultOrderEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)eo);
        eo.setId(((CsDeliveryResultOrderEo)list.get(0)).getId());
        this.csDeliveryResultOrderMapper.updateById((BaseEo)eo);
    }

    @Override
    public Long createDeliveryResultOrder(String relevanceNo, String preOrderNo) {
        this.repeatFilter.checkRepeat("DeliveryResult:" + relevanceNo + preOrderNo, () -> this.preValid(relevanceNo), true);
        String outResultDocumentNo = this.csOutResultOrderQueryService.queryDocumentByPreOrderNo(preOrderNo);
        CsOutResultOrderRespDto dto = this.csOutResultOrderQueryService.queryByDocumentNo(outResultDocumentNo);
        CsDeliveryNoticeOrderRespDto deliveryNoticeOrderRespDto = this.csDeliveryNoticeOrderQueryService.queryByPreOrderNo(dto.getPreOrderNo());
        dto.setWarehouseId(deliveryNoticeOrderRespDto.getWarehouseId());
        dto.setWarehouseCode(deliveryNoticeOrderRespDto.getWarehouseCode());
        dto.setWarehouseName(deliveryNoticeOrderRespDto.getWarehouseName());
        dto.setOrganizationId(deliveryNoticeOrderRespDto.getOrganizationId());
        dto.setOrganizationName(deliveryNoticeOrderRespDto.getOrganizationName());
        CsDeliveryResultOrderEo csDeliveryResultOrderEo = new CsDeliveryResultOrderEo();
        CubeBeanUtils.copyProperties((Object)csDeliveryResultOrderEo, (Object)dto, (String[])new String[0]);
        CsGenerateCodeEnum generateCodeEnum = this.simpleGenerateCodeUtil.generateCode("102");
        String documentNo = generateCodeEnum.getCode();
        String orderStatus = generateCodeEnum.getStatus();
        csDeliveryResultOrderEo.setDocumentNo(documentNo);
        csDeliveryResultOrderEo.setOrderStatus(orderStatus);
        csDeliveryResultOrderEo.setRelevanceNo(relevanceNo);
        csDeliveryResultOrderEo.setExtension(JSON.toJSONString((Object)dto.getContactDto()));
        this.csDeliveryResultOrderMapper.insert((Object)csDeliveryResultOrderEo);
        Map<String, Long> activityIdMap = this.queryActivityMap(relevanceNo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsOutResultOrderDetailRespDto detailRespDto : dto.getDetailRespDtoList()) {
            CsDeliveryResultOrderDetailEo detailEo = new CsDeliveryResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)dto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailRespDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(documentNo);
            detailEo.setRelevanceNo(relevanceNo);
            detailEo.setArtNo(this.csCommonService.getItemCode(detailEo.getCargoCode()));
            detailEo.setActivityId(activityIdMap.get(detailRespDto.getCargoCode() + detailRespDto.getBatch() + detailRespDto.getTradeOrderItemId()));
            detailEoList.add(detailEo);
        }
        this.csDeliveryResultOrderDetailMapper.insertBatch((List)detailEoList);
        return csDeliveryResultOrderEo.getId();
    }

    private Map<String, Long> queryActivityMap(String relevanceNo) {
        HashMap<String, Long> activityIdMap = new HashMap<String, Long>();
        List noticeOrderDetailEoList = this.csDeliveryNoticeOrderDetailMapper.queryByDocumentNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)noticeOrderDetailEoList)) {
            for (CsDeliveryNoticeOrderDetailEo detailEo : noticeOrderDetailEoList) {
                activityIdMap.put(detailEo.getCargoCode() + detailEo.getBatch() + detailEo.getTradeOrderItemId(), detailEo.getActivityId());
            }
        }
        return activityIdMap;
    }

    private void preValid(String relevanceNo) {
        List oldList = this.csDeliveryResultOrderMapper.queryByRelevanceNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (CsDeliveryResultOrderEo deliveryResultOrderEo : oldList) {
                AssertUtil.isTrue(CsOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(deliveryResultOrderEo.getOrderStatus()), deliveryResultOrderEo.getPreOrderNo() + "\u5df2\u5b58\u5728\u6d41\u8f6c\u6b63\u5e38\u7684\u524d\u7f6e\u5355\u636e");
            }
        }
    }
}

