/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.log.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.log.ICsInventoryYxyDailyService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLogicInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.log.CsInventoryYxyDailyEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsLogicInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.log.CsInventoryYxyDailyMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsInventoryYxyDailyAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csInventoryYxyDailyService")
public class CsInventoryYxyDailyServiceImpl
implements ICsInventoryYxyDailyService {
    private static Logger logger = LoggerFactory.getLogger(CsInventoryYxyDailyServiceImpl.class);
    @Autowired
    private CsInventoryYxyDailyMapper csInventoryYxyDailyMapper;
    @Autowired
    private CsLogicInventoryMapper csLogicInventoryMapper;

    @Override
    public void add(List<CsInventoryYxyDailyAddReqDto> list) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(list));
        Map<String, List<CsInventoryYxyDailyAddReqDto>> map = list.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getWarehouseCode()) && StringUtils.isNotBlank((CharSequence)e.getCargoCode()) && StringUtils.isNotBlank((CharSequence)e.getBatch())).collect(Collectors.groupingBy(CsInventoryYxyDailyAddReqDto::getWarehouseCode));
        if (null == map || map.isEmpty() || CollectionUtils.isEmpty(map.keySet())) {
            logger.info("\u8bf7\u6c42\u6570\u636e\u5f02\u5e38");
        }
        logger.info("map:{}", (Object)JSON.toJSONString(map));
        Date now = new Date();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        updateWrapper.in((Object)"warehouse_code", map.keySet());
        CsInventoryYxyDailyEo updateEo = new CsInventoryYxyDailyEo();
        updateEo.setValid(CsValidFlagEnum.DISABLE.getCode());
        updateEo.setUpdateTime(now);
        this.csInventoryYxyDailyMapper.update((Object)updateEo, (Wrapper)updateWrapper);
        QueryWrapper deleteWrapper = new QueryWrapper();
        Date date = DateUtils.addDays((Date)now, (int)-5);
        deleteWrapper.lt((Object)"create_time", (Object)date);
        deleteWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.DISABLE.getCode());
        deleteWrapper.in((Object)"warehouse_code", map.keySet());
        List yxyDailyEos = this.csInventoryYxyDailyMapper.selectList((Wrapper)deleteWrapper);
        if (CollectionUtils.isNotEmpty((Collection)yxyDailyEos)) {
            this.csInventoryYxyDailyMapper.delete((Wrapper)deleteWrapper);
        }
        for (Map.Entry<String, List<CsInventoryYxyDailyAddReqDto>> entry : map.entrySet()) {
            List eos;
            if (StringUtils.isBlank((CharSequence)entry.getKey()) || CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            HashMap<String, CsInventoryYxyDailyEo> yxyMap = new HashMap<String, CsInventoryYxyDailyEo>();
            entry.getValue().forEach(dto -> {
                String key = (StringUtils.isBlank((CharSequence)dto.getWarehouseCode()) ? "" : dto.getWarehouseCode()) + (StringUtils.isBlank((CharSequence)dto.getCargoCode()) ? "" : dto.getCargoCode()) + (StringUtils.isBlank((CharSequence)dto.getBatch()) ? "" : dto.getBatch());
                CsInventoryYxyDailyEo eo = new CsInventoryYxyDailyEo();
                CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
                eo.setDifference(dto.getQuantity().negate());
                eo.setRemark("\u5e93\u5b58\u4e2d\u5fc3\u4e0d\u5b58\u5728\u6b64\u6570\u636e");
                yxyMap.put(key, eo);
            });
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"warehouse_code", (Object)entry.getKey());
            queryWrapper.eq((Object)"dr", (Object)0);
            List queryList = this.csLogicInventoryMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)queryList)) {
                for (CsLogicInventoryEo eo : queryList) {
                    String key = (StringUtils.isBlank((CharSequence)eo.getWarehouseCode()) ? "" : eo.getWarehouseCode()) + (StringUtils.isBlank((CharSequence)eo.getCargoCode()) ? "" : eo.getCargoCode()) + (StringUtils.isBlank((CharSequence)eo.getBatch()) ? "" : eo.getBatch());
                    if (!Objects.nonNull(yxyMap.get(key))) continue;
                    CsInventoryYxyDailyEo insertEo = (CsInventoryYxyDailyEo)yxyMap.get(key);
                    insertEo.setValid(CsValidFlagEnum.ENABLE.getCode());
                    BigDecimal balance = Objects.isNull(eo.getBalance()) ? BigDecimal.ZERO : eo.getBalance();
                    insertEo.setBalance(balance);
                    insertEo.setDifference(balance.subtract(insertEo.getQuantity()));
                    insertEo.setRemark("");
                    yxyMap.put(key, insertEo);
                }
            }
            if (!CollectionUtils.isNotEmpty(eos = yxyMap.values().stream().filter(e -> BigDecimal.ZERO.compareTo(e.getDifference()) != 0).collect(Collectors.toList()))) continue;
            this.csInventoryYxyDailyMapper.insertBatch(eos);
            logger.info("\u6839\u636e\u4ed3\u5e93\u7f16\u7801\uff1a{} \u5df2\u65b0\u589e\u8425\u9500\u4e91\u5e93\u5b58\u4e0e\u5e93\u5b58\u4e2d\u5fc3\u903b\u8f91\u6279\u6b21\u8868\u5bf9\u6bd4\u8bb0\u5f55\uff0c\u5171\uff1a{}\u6761", (Object)entry.getKey(), (Object)yxyMap.size());
        }
    }
}

