/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsDeliveryNoticeOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsDeliveryResultOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryNoticeOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryResultOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsDeliveryResultOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="csDeliveryResultOrderQueryService")
public class CsDeliveryResultOrderQueryServiceImpl
implements ICsDeliveryResultOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsDeliveryResultOrderQueryServiceImpl.class);
    @Resource
    private CsDeliveryNoticeOrderMapper csDeliveryNoticeOrderMapper;
    @Resource
    private CsDeliveryResultOrderMapper csDeliveryResultOrderMapper;
    @Resource
    private CsDeliveryResultOrderDetailMapper csDeliveryResultOrderDetailMapper;
    @Resource
    private CsCommonService csCommonService;

    @Override
    public CsDeliveryResultOrderEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsDeliveryResultOrderEo csDeliveryResultOrderEo = (CsDeliveryResultOrderEo)this.csDeliveryResultOrderMapper.selectById((Serializable)id);
        return csDeliveryResultOrderEo;
    }

    @Override
    public CsDeliveryResultOrderRespDto queryById(Long id) {
        List resultOrderEoList;
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsDeliveryResultOrderEo csDeliveryResultOrderEo = (CsDeliveryResultOrderEo)this.csDeliveryResultOrderMapper.selectById((Serializable)id);
        AssertUtil.isTrue(csDeliveryResultOrderEo != null && csDeliveryResultOrderEo.getId() != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"document_no", (Object)csDeliveryResultOrderEo.getDocumentNo());
        List detailEoList = this.csDeliveryResultOrderDetailMapper.selectList((Wrapper)wrapper);
        CsDeliveryResultOrderRespDto dto = new CsDeliveryResultOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)csDeliveryResultOrderEo, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            ArrayList orderDetailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)orderDetailRespDtoList, (Collection)detailEoList, CsDeliveryResultOrderDetailRespDto.class);
            dto.setDeliveryResultOrderDetailRespDtoList((List)orderDetailRespDtoList);
        }
        if (StringUtils.isNotBlank((CharSequence)csDeliveryResultOrderEo.getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)csDeliveryResultOrderEo.getExtension(), ContactDto.class);
                dto.setContactDto(contactDto);
            }
            catch (Exception ex) {
                logger.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(resultOrderEoList = this.csDeliveryNoticeOrderMapper.queryByDocumentNo(csDeliveryResultOrderEo.getRelevanceNo())))) {
            List noticeNo = resultOrderEoList.stream().map(CsDeliveryNoticeOrderEo::getDocumentNo).collect(Collectors.toList());
            dto.setNoticeNo(noticeNo);
        }
        return dto;
    }

    @Override
    public CsDeliveryResultOrderRespDto queryByDocumentNo(String documentNo) {
        List list = this.csDeliveryResultOrderMapper.queryByDocumentNo(documentNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u53f7\u4e0d\u5b58\u5728");
        return this.queryById(((CsDeliveryResultOrderEo)list.get(0)).getId());
    }

    @Override
    public CsDeliveryResultOrderRespDto queryByPreOrderNo(String preOrderNo) {
        List list = this.csDeliveryResultOrderMapper.queryByPreOrderNo(preOrderNo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return this.queryById(((CsDeliveryResultOrderEo)list.get(0)).getId());
    }

    @Override
    public PageInfo<CsDeliveryResultOrderRespDto> queryByPage(CsDeliveryResultOrderQueryDto queryDto) {
        logger.info("\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper wrapper = new QueryWrapper();
        Long organizationId = this.csCommonService.getUserOrganizationId();
        if (null != organizationId) {
            wrapper.eq((Object)"organization_id", (Object)organizationId);
        }
        if (StringUtil.isNotBlank((String)queryDto.getBusinessType())) {
            wrapper.eq((Object)"business_type", (Object)queryDto.getBusinessType());
        }
        if (StringUtil.isNotBlank((String)queryDto.getOrderStatus())) {
            wrapper.eq((Object)"order_status", (Object)queryDto.getOrderStatus());
        }
        if (StringUtil.isNotBlank((String)queryDto.getPreOrderNo())) {
            wrapper.eq((Object)"pre_order_no", (Object)queryDto.getPreOrderNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getDocumentNo())) {
            wrapper.like((Object)"document_no", (Object)queryDto.getDocumentNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((String)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        if (Objects.nonNull(queryDto.getIsExpress())) {
            if (YesNoEnum.NO.getValue().equals(queryDto.getIsExpress())) {
                wrapper.isNull((Object)"shipping_code");
            } else {
                wrapper.isNotNull((Object)"shipping_code");
            }
        }
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.csDeliveryResultOrderMapper.selectList((Wrapper)wrapper);
        PageInfo info = new PageInfo(list);
        List rList = list.stream().map(t -> {
            CsDeliveryResultOrderRespDto dto = new CsDeliveryResultOrderRespDto();
            try {
                org.apache.commons.beanutils.BeanUtils.copyProperties((Object)dto, (Object)t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return dto;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo(rList);
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(rList);
        logger.info("\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    @Override
    public List<CsDeliveryResultOrderEo> queryByRelevanceNo(String relevanceNo) {
        List resultOrderEoList = this.csDeliveryResultOrderMapper.queryByRelevanceNo(relevanceNo);
        return resultOrderEoList;
    }
}

