CREATE TABLE `in_dra_order`
(
    `no`             varchar(50) NOT NULL COMMENT '单据编码',
    `category`       varchar(10) NOT NULL DEFAULT '101' COMMENT '101发货通知单/102发货结果单  201收货通知单/202收货结果单   301调整单',
    `type`           int(10)     NULL     DEFAULT '101' COMMENT '业务类型 101订单销售出库/102调拨出库/103盘亏出库/104其他出库/105库存调整出库  201采购入库/202调拨入库/203盘盈入库/204其他入库',
    `status`         int(10)     NOT NULL DEFAULT '1011' COMMENT '1011待审核/1012出库/1013出库中/1014已完成/1015已取消   1021全部发货    2011已锁定/2012待配发/2013已配发/2014待收货/2015已完成     3011待审核/3012已调整/3013审批拒绝',
    `num`            bigint(20)  NOT NULL DEFAULT '0' COMMENT '商品数量',
    `pre_no`         varchar(50)          DEFAULT NULL COMMENT '前置业务单据',
    `pre_recive_name` varchar(50)         DEFAULT NULL COMMENT '前置单收货人',
    `pre_recive_phone` varchar(50)        DEFAULT NULL COMMENT '前置单手机',
    `pre_address`      varchar(50)        DEFAULT NULL COMMENT '前置单地址',
    `pre_plan_time`    varchar(50)        DEFAULT NULL COMMENT '前置单计划时间',
    `pre_remark`       varchar(50)        DEFAULT NULL COMMENT '前置单备注',
    `warehouse_id`   bigint(20)           DEFAULT NULL COMMENT '仓库ID',
    `warehouse_code` varchar(60)          DEFAULT NULL COMMENT '仓库编码',
    `warehouse_name` varchar(60)          DEFAULT NULL COMMENT '仓库名称',
    `express_co`     varchar(60)          DEFAULT NULL COMMENT '物流公司',
    `express_no`     varchar(60)          DEFAULT NULL COMMENT '物流编码',
    `audit_person`   varchar(60)          DEFAULT NULL COMMENT '审核人',
    `audit_time`     datetime             DEFAULT NULL COMMENT '审核时间',
    `remark`         varchar(255)         DEFAULT NULL COMMENT '备注',
    `id`             bigint(20)  NOT NULL COMMENT '主键ID',
    `extension`      varchar(1024)        DEFAULT '' COMMENT '扩展字段',
    `tenant_id`      bigint(20)  NOT NULL DEFAULT '-1' COMMENT '租户ID',
    `instance_id`    bigint(20)  NOT NULL DEFAULT '-1' COMMENT '应用实例ID',
    `create_time`    datetime    NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `create_person`  varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
    `update_time`    datetime    NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    `update_person`  varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
    `dr`             tinyint(1)  NOT NULL DEFAULT '0' COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_warehouse_id` (`warehouse_id`) USING BTREE,
    KEY `idx_no` (`no`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  ROW_FORMAT = DYNAMIC COMMENT ='[收发调]货单据';

ALTER TABLE `in_dra_order`
    ADD COLUMN `noti_no` varchar(50) NULL COMMENT '通知单号' AFTER `pre_no`;
ALTER TABLE `in_dra_order`
    ADD COLUMN `warepos` varchar(60) NULL COMMENT '库位' AFTER `warehouse_name`;


CREATE TABLE `in_dra_order_cargo`
(
    `order_no`       varchar(50) NOT NULL COMMENT '单据编码',
    `order_id`       bigint(20)  NOT NULL COMMENT '主键ID',
    `batch`          varchar(50)          DEFAULT NULL COMMENT '批次',
    `cargo_id`       bigint(20)           DEFAULT NULL COMMENT '商品ID',
    `cargo_code`     varchar(60)          DEFAULT NULL COMMENT '商品编码',
    `cargo_name`     varchar(60)          DEFAULT NULL COMMENT '商品名称',
    `cargo_no`       varchar(60)          DEFAULT NULL COMMENT '商品货号',
    `warehouse_id`   bigint(20)           DEFAULT NULL COMMENT '仓库ID',
    `warehouse_code` varchar(60)          DEFAULT NULL COMMENT '仓库编码',
    `warehouse_name` varchar(60)          DEFAULT NULL COMMENT '仓库名称',
    `num`            bigint(20)  NOT NULL DEFAULT '0' COMMENT '其他单:变动数量',
    `plan_num`       bigint(20)  NOT NULL DEFAULT '0' COMMENT '通知单:计划数量',
    `sent_num`       bigint(20)  NOT NULL DEFAULT '0' COMMENT '通知单:已发数量',
    `wait_num`       bigint(20)  NOT NULL DEFAULT '0' COMMENT '通知单:待发数量',
    `cancel_num`     bigint(20)  NOT NULL DEFAULT '0' COMMENT '通知单:取消数量',
    `id`             bigint(20)  NOT NULL COMMENT '主键ID',
    `remark`         varchar(255)         DEFAULT NULL COMMENT '备注',
    `extension`      varchar(1024)        DEFAULT '' COMMENT '扩展字段',
    `tenant_id`      bigint(20)  NOT NULL DEFAULT '-1' COMMENT '租户ID',
    `instance_id`    bigint(20)  NOT NULL DEFAULT '-1' COMMENT '应用实例ID',
    `create_time`    datetime    NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `create_person`  varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
    `update_time`    datetime    NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    `update_person`  varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
    `dr`             tinyint(1)  NOT NULL DEFAULT '0' COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_order_no` (`order_no`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  ROW_FORMAT = DYNAMIC COMMENT ='单据货品';


CREATE TABLE `in_cargo_occupy`
(
    `order_no`       varchar(50) NOT NULL COMMENT '单据编码',
    `batch`          varchar(50)          DEFAULT NULL COMMENT '批次',
    `cargo_id`       bigint(20)           DEFAULT NULL COMMENT '商品ID',
    `cargo_code`     varchar(60)          DEFAULT NULL COMMENT '商品编码',
    `cargo_name`     varchar(60)          DEFAULT NULL COMMENT '商品名称',
    `cargo_no`       varchar(60)          DEFAULT NULL COMMENT '商品货号',
    `warehouse_id`   bigint(20)           DEFAULT NULL COMMENT '仓库ID',
    `warehouse_code` varchar(60)          DEFAULT NULL COMMENT '仓库编码',
    `warehouse_name` varchar(60)          DEFAULT NULL COMMENT '仓库名称',
    `warepos`        varchar(60)          DEFAULT NULL COMMENT '库位',
    `num`            bigint(20)  NOT NULL DEFAULT '0' COMMENT '数量',
    `valid`          bigint(10)  NOT NULL DEFAULT '1' COMMENT '1有效,-1无效',
    `id`             bigint(20)  NOT NULL COMMENT '主键ID',
    `remark`         varchar(255)         DEFAULT NULL COMMENT '备注',
    `extension`      varchar(1024)        DEFAULT '' COMMENT '扩展字段',
    `tenant_id`      bigint(20)  NOT NULL DEFAULT '-1' COMMENT '租户ID',
    `instance_id`    bigint(20)  NOT NULL DEFAULT '-1' COMMENT '应用实例ID',
    `create_time`    datetime    NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `create_person`  varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
    `update_time`    datetime    NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    `update_person`  varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
    `dr`             tinyint(1)  NOT NULL DEFAULT '0' COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_order_no` (`order_no`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  ROW_FORMAT = DYNAMIC COMMENT ='货品库存占用';
