/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.svr.rest;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.IMqCommonsService;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/inventory"})
public class InventoryRest
implements IInventoryApi {
    @Resource
    ICommonsMqService commonsMqService;
    @Resource
    IMqCommonsService commonsService;
    private static Logger logger = LoggerFactory.getLogger(InventoryRest.class);
    @Resource(name="${yunxi.dg.base.project}_InventoryApi")
    IInventoryApi inventoryApi;

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> logicPreempt(@Validated @RequestBody PreemptDto param) {
        return this.inventoryApi.logicPreempt(param);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<Void> releaseLogicPreempt(@Validated @RequestBody ReleasePreemptDto param) {
        return this.inventoryApi.releaseLogicPreempt(param);
    }
}

