/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.svr.rest.cs.order.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedDifferenceAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedRelieveDifferenceReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderResultRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderDetailRespDto;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/csOutPlannedOrder"})
public class CsOutPlannedOrderRest
implements ICsOutPlannedOrderApi,
ICsOutPlannedOrderQueryApi {
    private static Logger logger = LoggerFactory.getLogger(CsOutPlannedOrderRest.class);
    @Resource(name="${yunxi.dg.base.project}_OutPlannedOrderApi")
    private ICsOutPlannedOrderApi csOutPlannedOrderApi;
    @Resource(name="${yunxi.dg.base.project}_OutPlannedOrderQueryApi")
    private ICsOutPlannedOrderQueryApi csOutPlannedOrderQueryApi;

    public RestResponse<Long> add(@Validated @RequestBody CsOutPlannedOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)addReqDto));
        return this.csOutPlannedOrderApi.add(addReqDto);
    }

    public RestResponse<Void> update(@PathVariable(value="id") Long id, @Validated @RequestBody CsOutPlannedOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent((Object)updateReqDto));
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u53c2\u6570\u6709\u8bef");
        return this.csOutPlannedOrderApi.update(id, updateReqDto);
    }

    public RestResponse<Void> delete(@PathVariable(value="id") Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u53c2\u6570\u6709\u8bef");
        return this.csOutPlannedOrderApi.delete(id);
    }

    public RestResponse<Long> generateRetreatOrder(CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        return this.csOutPlannedOrderApi.generateRetreatOrder(plannedOrderGenerateReqDto);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<CsOutPlannedOrderResultRespDto> auditRetreatOrder(CsOutPlannedOrderAuditReqDto plannedOrderAuditReqDto) {
        return this.csOutPlannedOrderApi.auditRetreatOrder(plannedOrderAuditReqDto);
    }

    public RestResponse<Void> cancelByOrderNo(String orderNo) {
        this.csOutPlannedOrderApi.cancelByOrderNo(orderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Long> editRetreatOrder(CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        return this.csOutPlannedOrderApi.editRetreatOrder(plannedOrderGenerateReqDto);
    }

    public RestResponse<Void> submitByOrderNo(String orderNo) {
        this.csOutPlannedOrderApi.submitByOrderNo(orderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> relieveDifferenceByOrderDocumentNo(CsOutPlannedRelieveDifferenceReqDto outPlannedRelieveDifferenceReqDto) {
        this.csOutPlannedOrderApi.relieveDifferenceByOrderDocumentNo(outPlannedRelieveDifferenceReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> differenceAdjust(CsOutPlannedDifferenceAdjustReqDto differenceAdjustReqDto) {
        this.csOutPlannedOrderApi.differenceAdjust(differenceAdjustReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<CsOutPlannedOrderRespDto> queryByPrimaryKey(@PathVariable(value="id") Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u53c2\u6570\u6709\u8bef");
        return this.csOutPlannedOrderQueryApi.queryByPrimaryKey(id);
    }

    public RestResponse<PageInfo<CsOutPlannedOrderRespDto>> queryByPage(CsOutPlannedOrderPageQueryDto outPlannedOrderPageQueryDto) {
        return this.csOutPlannedOrderQueryApi.queryByPage(outPlannedOrderPageQueryDto);
    }

    public RestResponse<CsOutPlannedOrderDetailQueryInfoRespDto> queryDetailByOrderNo(String orderNo) {
        return this.csOutPlannedOrderQueryApi.queryDetailByOrderNo(orderNo);
    }

    public RestResponse<List<CsOutResultOrderDetailRespDto>> queryDifferenceDetailByDocumentNo(String resultDocumentNo) {
        return this.csOutPlannedOrderQueryApi.queryDifferenceDetailByDocumentNo(resultDocumentNo);
    }

    public RestResponse<List<CsOutPlannedOrderRespDto>> queryByIds(List<Long> ids) {
        return this.csOutPlannedOrderQueryApi.queryByIds(ids);
    }
}

