package com.dtyunxi.yundt.cube.center.item.api.base.constants;

public enum RateByWeekEnum {

    MONDAY(1, "星期一"),
    TUESDAY(2, "星期二"),
    WEDNESDAY(3, "星期三"),
    THURSDAY(4, "星期四"),
    FRIDAY(5, "星期五"),
    SATURDAY(6, "星期六"),
    SUNDAY(7, "星期日");

    private int code;

    private String name;

    RateByWeekEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static RateByWeekEnum getByCode(int code) {
        for (RateByWeekEnum data : RateByWeekEnum.values()) {
            if (code == data.getCode()) {
                return data;
            }
        }
        return null;
    }


    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
