/**
 * @(#)DrEnum.java 1.0 2018年8月31日
 *
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.constants;

/**
 * 删除标识
 * 
 * @author 佐助
 * @since 2.0.0
 */
public enum DrEnum {

	VALID(0, "未删除"), 
	DELETED(1, "已删除");

	private Integer code;
	private String text;

	private DrEnum(Integer code, String text) {
		this.code = code;
		this.text = text;
	}

	public Integer getCode() {
		return code;
	}

	public String getText() {
		return text;
	}

	/**
	 * 根据code获取text
	 * 
	 * @param code
	 *            状态编码
	 * @return 状态说明
	 */
	public static String getText(Integer code) {
		if (code == null) {
			return null;
		}
		for (DrEnum drEnum : DrEnum.values()) {
			if (code.equals(drEnum.getCode())) {
				return drEnum.getText();
			}
		}
		return null;
	}

}
