package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 商品变更申请Dto
 *
 * @author 风影
 * @since 2.0.0
 */
@ApiModel(value = "ItemChangeApplyReqDto", description = "商品变更申请Dto")
public class ItemChangeApplyReqDto extends BaseReqDto {
    /**
     * 商品版本id
     */
    @ApiModelProperty(name = "id", value = "申请变更id，新增时选填，修改时必填")
    private Long id;
    /**
     * 版本编号
     */
    @ApiModelProperty(name = "code", value = "版本编号")
    private String code;
    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id，非必填")
    private Long itemId;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称，必填")
    private String itemName;
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码，选填")
    private String itemCode;
    /**
     * 商品类型1普通商品2产品3组合商品 默认1
     */
    @ApiModelProperty(name = "type", value = "商品类型1普通商品2产品3组合商品，选填，默认1")
    private Integer type;
    /**
     * 状态(状态,0草稿、1待审核、2审核通过、3审核不通过)
     */
    @ApiModelProperty(name = "status", value = "状态,0草稿、1待审核、2审核通过、3审核不通过")
    private Integer status;
    /**
     * 不等于该状态
     */
    @ApiModelProperty(name = "neStatus", value = "不等于该状态(因为列表查询的时候，查询不可用的状态有很多)")
    private Integer neStatus;

    /**
     * 商品信息
     */
    @ApiModelProperty(name = "itemChangeApplyDto", value = "新的变更申请，必填")
    private ItemChangeApplyDto itemChangeApplyDto;
    /**
     * 所属人ID
     */
    @NotNull(message = "所属人ID不能为null")
    @ApiModelProperty(name = "ownerId", value = "所属人ID，必填，可传入userId")
    private Long ownerId;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "brand", value = "品牌名称，选填")
    private String brand;

    /**
     * 品牌ID
     */
    @ApiModelProperty(name = "brandId", value = "品牌ID，必填")
    private Long brandId;

    /**
     * 目录Id
     */
    @ApiModelProperty(name = "dirId", value = "目录ID，选填")
    private Long dirId;
    /**
     * 目录名称
     */
    @ApiModelProperty(name = "dirName", value = "目录名称，选填")
    private String dirName;
    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID，选填")
    private Long sellerId;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID，选填")
    private Long shopId;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(name = "createBeginTime", value = "创建开始时间，查询时使用")
    private String createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建结束时间，查询时使用")
    private String createEndTime;
    /**
     * 更新开始时间
     */
    @ApiModelProperty(name = "updateBeginTime", value = "更新开始时间，查询时使用")
    private String updateBeginTime;
    /**
     * 更新结束时间
     */
    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间，查询时使用")
    private String updateEndTime;

    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购  默认0")
    private Integer busType;


    /**
     * 供应商Id
     */
    @ApiModelProperty(name = "supplierId", value = "供应商id,选填")
    private Long supplierId;

    @ApiModelProperty(name = "saleChannel", value = "可售渠道,多个用英文逗号隔开,如：JD,TM")
    private String saleChannel;

    @ApiModelProperty(name = "year", value = "所属年份")
    private Integer year;

    /**
     * 组织Id
     */
    @ApiModelProperty(name = "organizationId", value = "组织Id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    @ApiModelProperty(
            name = "giftBox",
            value = "是否礼盒（0：是、1：否）"
    )
    private Integer giftBox;

    public Integer getGiftBox() {
        return giftBox;
    }

    public void setGiftBox(Integer giftBox) {
        this.giftBox = giftBox;
    }

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getNeStatus() {
        return neStatus;
    }

    public void setNeStatus(Integer neStatus) {
        this.neStatus = neStatus;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(String createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }

    public String getUpdateBeginTime() {
        return updateBeginTime;
    }

    public void setUpdateBeginTime(String updateBeginTime) {
        this.updateBeginTime = updateBeginTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    public ItemChangeApplyDto getItemChangeApplyDto() {
        return itemChangeApplyDto;
    }

    public void setItemChangeApplyDto(ItemChangeApplyDto itemChangeApplyDto) {
        this.itemChangeApplyDto = itemChangeApplyDto;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Integer getBusType() {
        return busType;
    }
    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public String getSaleChannel() {
        return saleChannel;
    }

    public void setSaleChannel(String saleChannel) {
        this.saleChannel = saleChannel;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }
}
