package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
* 商品对应的授权表的外部系统编码
* @author lshaowu
* @time 2022/8/15 18:22
* @description
*/
@Data
@ApiModel(value = "ItemAuthExtractCodeRespDto", description = "商品对应的授权表的商品id与外部系统编码")
public class ItemAuthExtractCodeRespDto extends BaseVo {
    /**
     *  商品表it_item的表id
     */
    @ApiModelProperty(name = "itemId", value = "商品表it_item的表id")
    private Long itemId;

    /**
     *  商品授权表it_item_auth的external_code字段。
     */
    @ApiModelProperty(name = "externalCode", value = "商品外部系统编码")
    private String externalCode;

    @ApiModelProperty(name = "itemAuthId",value = "商品授权表id")
    private Long itemAuthId;
}
