package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemControlPriceDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemPriceControlReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 价格管理表服务接口
*
* @author author
* @since 2022-08-10
*/
@Api(tags = {"价格管理表服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemPriceControl",
        url = "${yundt.cube.center.item.api:}")
public interface IItemPriceControlApi {

    /**
    * 新增价格管理表
    *
    * @param addReqDto 价格管理表请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增价格管理表", notes = "新增价格管理表")
    RestResponse<Long> addItemPriceControl(@RequestBody ItemPriceControlReqDto addReqDto);

    /**
    * 修改价格管理表
    *
    * @param modifyReqDto 价格管理表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改价格管理表", notes = "修改价格管理表")
    RestResponse<Void> modifyItemPriceControl(@RequestBody ItemPriceControlReqDto modifyReqDto);

    /**
     * 批量新增价格管理表
     *
     * @param addReqDtoList 批量新增价格管理表
     * @return 处理结果
     */
    @PutMapping("/batchAdd")
    @ApiOperation(value = "批量新增价格管理表", notes = "批量新增价格管理表")
    RestResponse<Void> batchAddItemPriceControl(@RequestBody List<ItemPriceControlReqDto> addReqDtoList);

    /**
     * 编辑价格管理表
     *
     * @param controlPriceDto 编辑价格管理表
     * @return 处理结果
     */
    @PutMapping("/batchModify")
    @ApiOperation(value = "修改价格管理表", notes = "修改价格管理表")
    RestResponse<Void> batchModifyItemPriceControl(@RequestBody ItemControlPriceDto controlPriceDto);

    /**
    * 删除价格管理表
    *
    * @param ids        价格管理表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除价格管理表", notes = "删除价格管理表")
    RestResponse<Void> removeItemPriceControl(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
