/**
 * @(#) ItemSearchRespDto.java 1.0 2018-08-28
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * 商品关键字查询Dto
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "ItemSearchRespDto", description = "商品关键字查询Dto")
public class ItemSearchRespDto extends BaseRespDto {
    private static final long serialVersionUID = 8083663404404268665L;

    /**
     * 商品列表
     */
    @ApiModelProperty(name = "pageInfo", value = "商品列表")
    private PageInfo<ItemRespDto> pageInfo;

    /**
     * 商品属性列表
     */
    @ApiModelProperty(name = "attributesList", value = "商品属性列表")
    private List<ItemAttributesRespDto> attributesList = Lists.newArrayList();

    /**
     * 商品目录列表
     */
    @ApiModelProperty(name = "directoryItemList", value = "商品目录列表")
    private List<DirectoryItemRespDto> directoryItemList = Lists.newArrayList();
    @ApiModelProperty(name = "rangeShopList", value = "在区域的店铺列表")
    private List<Long> rangeShopList;

    public List<Long> getRangeShopList() {
        return rangeShopList;
    }

    public void setRangeShopList(List<Long> rangeShopList) {
        this.rangeShopList = rangeShopList;
    }

    public PageInfo<ItemRespDto> getPageInfo() {
        return pageInfo;
    }

    public void setPageInfo(PageInfo<ItemRespDto> pageInfo) {
        this.pageInfo = pageInfo;
    }

    public List<ItemAttributesRespDto> getAttributesList() {
        return attributesList;
    }

    public void setAttributesList(List<ItemAttributesRespDto> attributesList) {
        this.attributesList = attributesList;
    }

    public List<DirectoryItemRespDto> getDirectoryItemList() {
        return directoryItemList;
    }
    public void setDirectoryItemList(List<DirectoryItemRespDto> directoryItemList) {
        this.directoryItemList = directoryItemList;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
