/*
 * @(#)ItemComparisonRelationRespDto.java 1.0 2021年09月18日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * <p>Title:ItemComparisonRelationRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/18 11:13
 * @since 0.1.0
 */
@ApiModel(value = "ItemComparisonRelationReqDto", description = "商品对照关系响应Dto对象")
public class ItemComparisonRelationRespDto extends BaseRespDto {
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    @ApiModelProperty(name = "code", value = "物料编码")
    private String code;
    @ApiModelProperty(name = "name", value = "物料名称")
    private String name;
    @ApiModelProperty(name = "itemShopPlatforms", value = "商品店铺平台关系List")
    private List<ItemShopPlatforms> itemShopPlatforms = Lists.newArrayList();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ItemShopPlatforms> getItemShopPlatforms() {
        return itemShopPlatforms;
    }

    public void setItemShopPlatforms(List<ItemShopPlatforms> itemShopPlatforms) {
        this.itemShopPlatforms = itemShopPlatforms;
    }

    @ApiModel(value = "ItemShopPlatforms", description = "商品店铺平台关系Dto对象")
    public static class ItemShopPlatforms{

        @ApiModelProperty(name = "id", value = "")
        private Long id;
        @ApiModelProperty(name = "comparisonId", value = "")
        private Long comparisonId;
        @ApiModelProperty(name = "platformId", value = "平台编码")
        private String platformId;
        @ApiModelProperty(name = "platformName", value = "平台名称")
        private String platformName;
        @ApiModelProperty(name = "shopId", value = "店铺ID")
        private Long shopId;
        @ApiModelProperty(name = "shopCode", value = "店铺编码")
        private String shopCode;
        @ApiModelProperty(name = "shopName", value = "店铺名称")
        private String shopName;
        @ApiModelProperty(name = "skuId", value = "平台SKU编码")
        private String skuId;
        @ApiModelProperty(name = "channelItemCode", value = "平台商品编码")
        private String channelItemCode;
        @ApiModelProperty(name = "channelItemName", value = "平台商品名称")
        private String channelItemName;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getComparisonId() {
            return comparisonId;
        }

        public void setComparisonId(Long comparisonId) {
            this.comparisonId = comparisonId;
        }


        public String getPlatformId() {
            return platformId;
        }

        public void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        public String getPlatformName() {
            return platformName;
        }

        public void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public Long getShopId() {
            return shopId;
        }

        public void setShopId(Long shopId) {
            this.shopId = shopId;
        }

        public String getShopCode() {
            return shopCode;
        }

        public void setShopCode(String shopCode) {
            this.shopCode = shopCode;
        }

        public String getShopName() {
            return shopName;
        }

        public void setShopName(String shopName) {
            this.shopName = shopName;
        }

        public String getSkuId() {
            return skuId;
        }

        public void setSkuId(String skuId) {
            this.skuId = skuId;
        }

        public String getChannelItemCode() {
            return channelItemCode;
        }

        public void setChannelItemCode(String channelItemCode) {
            this.channelItemCode = channelItemCode;
        }

        public String getChannelItemName() {
            return channelItemName;
        }

        public void setChannelItemName(String channelItemName) {
            this.channelItemName = channelItemName;
        }
    }
}
