package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

@ApiModel(value = "ItemShelfQueryRespDto", description = "上架商品查询返回Dto")
public class ItemShelfQueryRespDto {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "imgPath", value = "商品图片路径")
    private String imgPath;

    @ApiModelProperty(name = "skuCode", value = "SKU编码")
    private String skuCode;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    @ApiModelProperty(name = "itemStatus", value = "上架状态")
    private Integer itemStatus;

    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;

    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(name = "frontDirIdList", value = "前台类目Id")
    private List<Long> frontDirIdList;

    @ApiModelProperty(name = "frontDirNameList", value = "前台类目名称")
    private List<String> frontDirNameList;

    @ApiModelProperty(name = "skuList", value = "商品SKU信息")
    private List<ItemShelfSkuRespDto> skuList;

    @ApiModelProperty(name = "shelfType", value = "上架类型: 1 普通上架 2 周期购上架")
    private Integer shelfType;
    @ApiModelProperty(name = "itemType", value = "商品类型: 1 普通商品 4虚拟商品")
    private Integer itemType;
    @ApiModelProperty(name = "busType", value = "上架业务类型：0普通商品 2 积分商品")
    private Integer busType;
    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否")
    private Integer distribution;

    @ApiModelProperty(name = "brandId", value = "品牌ID")
    private Long brandId;

    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "dirId", value = "后台类目ID")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;

    @ApiModelProperty(name = "dirIdList", value = "后端类目id集合：[1级，2级，3级]形式")
    private List<Long> dirIdList;

    @ApiModelProperty(name = "dirNameList", value = "后端类目名称集合：[1级，2级，3级]形式")
    private List<String> dirNameList;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    @ApiModelProperty(name = "shopAuth", value = "商品sku是否已取消店铺授权：0否 1是")
    private Integer shopAuth;

    public Integer getShopAuth() {
        return shopAuth;
    }

    public void setShopAuth(Integer shopAuth) {
        this.shopAuth = shopAuth;
    }

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public List<Long> getDirIdList() {
        return dirIdList;
    }

    public void setDirIdList(List<Long> dirIdList) {
        this.dirIdList = dirIdList;
    }

    public List<String> getDirNameList() {
        return dirNameList;
    }

    public void setDirNameList(List<String> dirNameList) {
        this.dirNameList = dirNameList;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getImgPath() {
        return imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(Integer itemStatus) {
        this.itemStatus = itemStatus;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public List<ItemShelfSkuRespDto> getSkuList() {
        return skuList;
    }

    public void setSkuList(List<ItemShelfSkuRespDto> skuList) {
        this.skuList = skuList;
    }

    public Integer getShelfType() {
        return shelfType;
    }

    public void setShelfType(Integer shelfType) {
        this.shelfType = shelfType;
    }

    public Integer getDistribution() {
        return distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public List<Long> getFrontDirIdList() {
        return frontDirIdList;
    }

    public void setFrontDirIdList(List<Long> frontDirIdList) {
        this.frontDirIdList = frontDirIdList;
    }

    public List<String> getFrontDirNameList() {
        return frontDirNameList;
    }

    public void setFrontDirNameList(List<String> frontDirNameList) {
        this.frontDirNameList = frontDirNameList;
    }
}
