package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

@ApiModel(value = "PcpItemQueryDto", description = "查询Dto")
@Getter
@Setter
public class PcpItemQueryDto extends RequestDto {
    /**
     * 商品长编码集合查询
     */
    @ApiModelProperty(name = "longCodeList", value = "商品长编码集合查询")
    private List<String> longCodeList;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    /**
     * 商品旧编码
     */
    @ApiModelProperty(name = "oldLongCode", value = "商品旧编码")
    private String oldLongCode;

    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;
    /**
     * 1-有效 0-无效
     * // todo 类型变更 汤臣是List<Long>,秒可、北鼎、华帝是Long
     */
    @ApiModelProperty(name = "itemStatus", value = "1-有效 0-无效")
    private Object itemStatus;
    /**
     * 商品剂型 1-粉剂
     * todo 类型变更，从Long(北鼎、华帝)变成String(汤臣妙可)
     */
    @ApiModelProperty(name = "itemDrug", value = "商品剂型 1-粉剂")
    private String itemDrug;
    /**
     * 1-产品 2-赠品 3-促销物料
     */
    @ApiModelProperty(name = "itemType", value = "1-产品 2-赠品 3-促销物料")
    private Long itemType;

    @ApiModelProperty(name = "itemTypeName", value = "商品类型名称")
    private String itemTypeName;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;

    @ApiModelProperty(name = "productGroup", value = "商品组")
    private String productGroup;//'商品组',

    @ApiModelProperty(name = "productGroupName", value = "商品组名称")
    private String productGroupName;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";
}
