/*
 * @(#)ItemDetailRespDto.java 1.0 2021年09月14日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>Title:ItemDetailRespDto</p>
 * <p>Description: </p>
 * @author yiyun.lkh
 * @date 2021/9/14 22:09
 * @since 0.1.0
 */
@Data
@ApiModel(value = "ItemDetailRespDto", description = "商品详情Dto对象")
public class ItemDetailHdRespDto extends ItemRespDto {

    @ApiModelProperty(name = "dirIds", value = "后台类目数组")
    private List<String> dirIds;
    private List<String> dirPrefixIds;
    @ApiModelProperty(name = "medias", value = "商品多媒体")
    private List<ItemMediasRespDto> medias = Lists.newArrayList();
    @ApiModelProperty(name = "skuExtRespDtos", value = "sku信息")
    private List<ItemSkuRespDto> skuExtRespDtos;

    @ApiModelProperty(name = "price", value = "商品价格")
    private String price;
    @ApiModelProperty(name = "barCode", value = "条形码")
    private String barCode;
    @ApiModelProperty(name = "vitrual", value = "是否虚拟商品,0-否,1-是")
    private String vitrualVaule;

}
