package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemDepartmentPriceReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 出厂价同步记录服务接口
*
* @author author
* @since 2022-08-25
*/
@Api(tags = {"出厂价同步记录服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemDepartmentPrice",
        url = "${yundt.cube.center.item.api:}")
public interface IItemDepartmentPriceApi {

    /**
    * 新增出厂价同步记录
    *
    * @param addReqDto 出厂价同步记录请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增出厂价同步记录", notes = "新增出厂价同步记录")
    RestResponse<Long> addItemDepartmentPrice(@RequestBody ItemDepartmentPriceReqDto addReqDto);

    /**
     * 新增出厂价同步记录
     *
     * @param priceReqDtoList 出厂价同步记录请求对象
     * @return 处理结果
     */
    @PostMapping("/batchAdd")
    @ApiOperation(value = "新增出厂价同步记录", notes = "新增出厂价同步记录")
    RestResponse<Void> batchAddItemDepartmentPrice(@RequestBody List<ItemDepartmentPriceReqDto> priceReqDtoList);

    /**
    * 修改出厂价同步记录
    *
    * @param modifyReqDto 出厂价同步记录请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改出厂价同步记录", notes = "修改出厂价同步记录")
    RestResponse<Void> modifyItemDepartmentPrice(@RequestBody ItemDepartmentPriceReqDto modifyReqDto);

    /**
     * 修改出厂价同步记录
     *
     * @param priceReqDtoList 出厂价同步记录请求对象
     * @return 处理结果
     */
    @PutMapping("/batchModify")
    @ApiOperation(value = "修改出厂价同步记录", notes = "修改出厂价同步记录")
    RestResponse<Void> batchModifyItemDepartmentPrice(@RequestBody List<ItemDepartmentPriceReqDto> priceReqDtoList);

    /**
     * 出厂价同步记录
     *
     * @param priceReqDtoList 出厂价同步记录请求对象
     * @return 处理结果
     */
    @PostMapping("/batchConduct")
    @ApiOperation(value = "修改出厂价同步记录", notes = "修改出厂价同步记录")
    RestResponse<Void> batchConductItemDepartmentPrice(@RequestBody List<ItemDepartmentPriceReqDto> priceReqDtoList);

    /**
    * 删除出厂价同步记录
    *
    * @param ids        出厂价同步记录删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除出厂价同步记录", notes = "删除出厂价同步记录")
    RestResponse<Void> removeItemDepartmentPrice(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
