/**
 * @(#) ItemAllowOrderReqDto.java 1.0 2019-03-01
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 检查商品是否在下单时间范围内请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemAllowOrderQueryReqDto", description = "检查商品是否在下单时间范围内请求Dto")
public class ItemAllowOrderQueryReqDto extends BaseReqDto {
    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
     * 规格ID
     */
    @ApiModelProperty(name = "skuId", value = "规格ID")
    private Long skuId;
    /**
     * 目录ID
     */
    @ApiModelProperty(name = "dirId", value = "目录ID")
    private Long dirId;
    /**
     * 价格类型ID
     */
    @ApiModelProperty(name = "priceId", value = "价格类型ID")
    private Long priceId;
    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getPriceId() {
        return priceId;
    }

    public void setPriceId(Long priceId) {
        this.priceId = priceId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
