package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "ItemSkuSapUpdateReqDto", description = "sap更新物料sku")
public class ItemSkuSapUpdateReqDto extends BaseVo {
    /**
     *创建日期
     * */
    @ApiModelProperty("创建日期")
    private Date createDate;
    @ApiModelProperty(name = "id", value = "id，选填(修改重新发布，要想规格id不变动可填)")
    private Long id;
    @ApiModelProperty(name = "itemId", value = "商品Id，必填")
    private Long itemId;
    @ApiModelProperty(name = "code", value = "编码，选填")
    private String code;
    @ApiModelProperty(name = "name", value = "规格名，必填")
    private String name;
    @ApiModelProperty(name = "cspuid", value = "产品规格，选填")
    private Long cspuid;
    @ApiModelProperty(name = "attr", value = "属性，必填")
    private String attr;
    @ApiModelProperty(name = "status", value = "状态，选填")
    private Integer status;
    @ApiModelProperty(name = "unit", value = "单位，选填")
    private String unit;
    @ApiModelProperty(name = "outterCode", value = "外部编码，选填(要跟库存关联则必填，为货品ID)")
    private String outterCode;
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    @ApiModelProperty(name = "barCode", value = "识别码，选填")
    private String barCode;
    @ApiModelProperty(name = "bundles", value = "组合信息，选填")
    private String bundles;
    @ApiModelProperty(name = "effectiveStartTime", value = "有效的起始时间（例12:00）,有效日期上架当天，选填(虚拟商品用)")
    private String effectiveStartTime;
    @ApiModelProperty(name = "effectiveEndTime", value = "有效的结束时间（例13:00）,有效日期上架当天，选填(虚拟商品用)")
    private String effectiveEndTime;
    @ApiModelProperty(name = "inventoryQuantity", value = "库存数量，选填(虚拟商品用)")
    private Long inventoryQuantity;
    @ApiModelProperty(name = "advanceSale", value = "是否预售(1是 2否)，选填(虚拟商品用)")
    private Integer advanceSale;
    @ApiModelProperty(name = "discontinuationDate", value = "停售日期，选填(虚拟商品用)")
    private String discontinuationDate;
    @ApiModelProperty(name = "shelfAmount", value = "可卖数量=所有规格的可卖数量之和，选填")
    private Long shelfAmount;
    @ApiModelProperty(name = "safetyStock", value = "安全库存数")
    private Integer safetyStock;
    @ApiModelProperty(name = "ifAvailableOffline", value = "是否线下可售，0-否，1-是")
    private Integer ifAvailableOffline;
    @ApiModelProperty(name = "gross_weight", value = "毛重，选填")
    private BigDecimal grossWeight;
    @ApiModelProperty(name = "gross_weight_unit", value = "毛重单位，选填")
    private String grossWeightUnit;
    @ApiModelProperty(name = "net_weight", value = "净重，选填")
    private BigDecimal netWeight;
    @ApiModelProperty(name = "net_weight_unit", value = "净重单位，选填")
    private String netWeightUnit;
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;
    @ApiModelProperty(name = "volumeUnit", value = "体积单位：1 立方米 2 立方厘米 3立方分米")
    private String volumeUnit;
    @ApiModelProperty(name = "balance", value = "库存数量")
    private Long balance;
    @ApiModelProperty(name = "price", value = "定价")
    private BigDecimal price;
    @ApiModelProperty(name = "salePrice", value = "零售价")
    private BigDecimal salePrice;
    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否")
    private Integer distribution;
    @ApiModelProperty(name = "distribution", value = "分销佣金")
    private BigDecimal distributionFee;
    @ApiModelProperty(name = "costPrice", value = "成本价")
    private BigDecimal costPrice;
    @ApiModelProperty(name = "addPriceStatus", value = "0:关闭加价限制;1:开启加价限制")
    private Integer addPriceStatus;
    @ApiModelProperty(name = "addPriceMode", value = "加价方式,0:使用默认值;1:自定义比例;2:自定义设置(固定值)")
    private Integer addPriceMode;
    @ApiModelProperty(name = "addPriceMin", value = "限制加价下限;addPriceMod的值为0,1就位百分比;2为固定值(单位元)")
    private String addPriceMin;
    @ApiModelProperty(name = "addPriceMax", value = "限制加价上限")
    private String addPriceMax;
    /**
     *冻结标识
     * */
    @ApiModelProperty(name = "freezeMark", value = "冻结标识")
    private String freezeMark;
    /*大小/量纲*/
    @ApiModelProperty(name = "capacitySize", value = "大小/量纲")
    private String capacitySize;
    /*面板材质/特征效果*/
    @ApiModelProperty(name = "panelMaterial", value = "面板材质/特征效果")
    private String panelMaterial;
    /*容积*/
    //String volume = null;
    /*毛质量*/
    @ApiModelProperty(name = "totalQuality", value = "毛质量")
    private String totalQuality;
    /*包装参考物料*/
    @ApiModelProperty(name = "packingMaterial", value = "包装参考物料")
    private String packingMaterial;
    /*包装外形尺寸*/
    @ApiModelProperty(name = "packingSize", value = "包装外形尺寸")
    private String packingSize;
    /*额定容积*/
    @ApiModelProperty(name = "nominalVolume", value = "额定容积")
    private String nominalVolume;
    /*净质量*/
    @ApiModelProperty(name = "netQuality", value = "净质量")
    private String netQuality ;
    /*嵌装开孔尺寸*/
    @ApiModelProperty(name = "insertOpeningSize", value = "嵌装开孔尺寸")
    private String insertOpeningSize;
    /*基本单位*/
    @ApiModelProperty(name = "basicUnit", value = "基本单位")
    private String basicUnit;
}
