package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModelProperty;

import java.util.List;

public class ItemOnShelfSearchDto {

    @ApiModelProperty(name = "outSkuIds", value = "在商品Sku的id集合外查询")
    private List<Long> outSkuIds;

    @ApiModelProperty(name = "skuIds", value = "指定 skuId 商品集合")
    private List<Long> skuIds;

    @ApiModelProperty(name = "searchValue", value = "商品名称/商品编码/属性")
    private String searchValue;

    @ApiModelProperty(name = "dirIds", value = "前台分类集合")
    private List<Long> dirIds;
    @ApiModelProperty(name = "backDirIds", value = "后台分类集合")
    private List<Long> backDirIds;

    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购 2 积分商品 3 赠品商品 默认0")
    private Integer busType;

    @ApiModelProperty("分页下标")
    private Integer pageNum;

    @ApiModelProperty("分页大小")
    private Integer pageSize;

    private Long instanceId;
    private Long tenantId;

    @ApiModelProperty("店铺 id")
    private Long shopId;

    @ApiModelProperty("Sku编码")
    private String skuCode;

    private List<Long> sellerIds;

    /**
     * 排除店铺id集合.
     */
    private List<Long> excludeShopIds;

    @ApiModelProperty("品牌 id")
    private Long brandId;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public List<Long> getSellerIds() {
        return sellerIds;
    }

    public void setSellerIds(List<Long> sellerIds) {
        this.sellerIds = sellerIds;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public List<Long> getBackDirIds() {
        return backDirIds;
    }

    public void setBackDirIds(List<Long> backDirIds) {
        this.backDirIds = backDirIds;
    }

    public List<Long> getOutSkuIds() {
        return outSkuIds;
    }

    public void setOutSkuIds(List<Long> outSkuIds) {
        this.outSkuIds = outSkuIds;
    }

    public List<Long> getSkuIds() {
        return skuIds;
    }

    public void setSkuIds(List<Long> skuIds) {
        this.skuIds = skuIds;
    }

    public String getSearchValue() {
        return searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public List<Long> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<Long> dirIds) {
        this.dirIds = dirIds;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public List<Long> getExcludeShopIds() {
        return excludeShopIds;
    }

    public void setExcludeShopIds(List<Long> excludeShopIds) {
        this.excludeShopIds = excludeShopIds;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }
}
