package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * <p>Title:ItemMainReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun
 * @date 2021/8/26 14:00
 * @since 0.1.0
 */
@ApiModel(value = "ItemMainReqDto", description = "商品主数据定义Dto对象")
public class ItemMainReqDto  {

    @ApiModelProperty(name = "itemCodes", value = "商品编码集合")
    private List<String> itemCodes;

    /**
     *  物料名称
     */
    @ApiModelProperty(name = "name", value = "物料名称")
    private String name;


    /**
     *  商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    /**
     *  后台类目
     */
    @ApiModelProperty(name = "dirId", value = "后台类目")
    private Long dirId;

    /**
     *  后台类目
     */
    @ApiModelProperty(name = "dirPrefixId", value = "前台类目")
    private Long dirPrefixId;


    /**
     * 添加开始时间
     */
    @ApiModelProperty(name = "addBeginTime",value = "添加开始时间")
    private String addBeginTime;

    /**
     * 添加结束时间
     */
    @ApiModelProperty(name = "addEndTime",value = "添加结束时间")
    private String addEndTime;

    /**
     * 创建开始时间
     */
    @ApiModelProperty(name = "createBeginTime",value = "创建开始时间")
    private String createBeginTime;

    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime",value = "创建结束时间")
    private String createEndTime;


    /**
     * 更新开始时间
     */
    @ApiModelProperty(name = "updateBeginTime",value = "更新开始时间")
    private String updateBeginTime;

    /**
     * 更新结束时间
     */
    @ApiModelProperty(name = "updateEndTime",value = "更新结束时间")
    private String updateEndTime;


    @ApiModelProperty(name = "selftStatus",value = "上架状态")
    private String selftStatus;

    @ApiModelProperty(
            name = "page",
            value = "当前页"
    )
    private Integer page;
    @ApiModelProperty(
            name = "size",
            value = "每页数"
    )
    private Integer size;

    @ApiModelProperty(name = "forward", value = "促销新增商品时使用")
    private String forward;

    @ApiModelProperty(name = "keyword", value = "根据关键字搜索")
    private String keyword;

    @ApiModelProperty(name = "prodLargeClass", value = "产品大类(北鼎一级品类描述)")
    private String prodLargeClass;
    @ApiModelProperty(name = "prodLargeCode", value = "产品大类编码(北鼎一级品类)")
    private String prodLargeCode;
    @ApiModelProperty(name = "prodSecClassify", value = "产品二级分类(北鼎二级品类描述)")
    private String prodSecClassify;
    @ApiModelProperty(name = "prodSecCode", value = "产品二级分类编码(北鼎二级品类)")
    private String prodSecCode;
    @ApiModelProperty(name = "prodThrClassify", value = "产品三级分类(北鼎三级品类描述)")
    private String prodThrClassify;
    @ApiModelProperty(name = "prodThrCode", value = "产品三级分类编码(北鼎三级品类)")
    private String prodThrCode;
    @ApiModelProperty(name = "prodClassCode", value = "产品型号")
    private String prodClassCode;
    @ApiModelProperty(name = "prodClassName", value = "产品名称")
    private String prodClassName;
    @ApiModelProperty(name = "gasClass", value = "燃气种类")
    private String gasClass;

    public String getGasClass() {
        return gasClass;
    }

    public void setGasClass(String gasClass) {
        this.gasClass = gasClass;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(String createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }

    public String getUpdateBeginTime() {
        return updateBeginTime;
    }

    public void setUpdateBeginTime(String updateBeginTime) {
        this.updateBeginTime = updateBeginTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getDirPrefixId() {
        return dirPrefixId;
    }

    public void setDirPrefixId(Long dirPrefixId) {
        this.dirPrefixId = dirPrefixId;
    }

    public String getSelftStatus() {
        return selftStatus;
    }

    public void setSelftStatus(String selftStatus) {
        this.selftStatus = selftStatus;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getAddBeginTime() {
        return addBeginTime;
    }

    public void setAddBeginTime(String addBeginTime) {
        this.addBeginTime = addBeginTime;
    }

    public String getAddEndTime() {
        return addEndTime;
    }

    public void setAddEndTime(String addEndTime) {
        this.addEndTime = addEndTime;
    }

    public String getForward() {
        return forward;
    }

    public void setForward(String forward) {
        this.forward = forward;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getProdLargeClass() {
        return prodLargeClass;
    }

    public void setProdLargeClass(String prodLargeClass) {
        this.prodLargeClass = prodLargeClass;
    }

    public String getProdLargeCode() {
        return prodLargeCode;
    }

    public void setProdLargeCode(String prodLargeCode) {
        this.prodLargeCode = prodLargeCode;
    }

    public String getProdSecClassify() {
        return prodSecClassify;
    }

    public void setProdSecClassify(String prodSecClassify) {
        this.prodSecClassify = prodSecClassify;
    }

    public String getProdSecCode() {
        return prodSecCode;
    }

    public void setProdSecCode(String prodSecCode) {
        this.prodSecCode = prodSecCode;
    }

    public String getProdThrClassify() {
        return prodThrClassify;
    }

    public void setProdThrClassify(String prodThrClassify) {
        this.prodThrClassify = prodThrClassify;
    }

    public String getProdThrCode() {
        return prodThrCode;
    }

    public void setProdThrCode(String prodThrCode) {
        this.prodThrCode = prodThrCode;
    }

    public String getProdClassCode() {
        return prodClassCode;
    }

    public void setProdClassCode(String prodClassCode) {
        this.prodClassCode = prodClassCode;
    }

    public String getProdClassName() {
        return prodClassName;
    }

    public void setProdClassName(String prodClassName) {
        this.prodClassName = prodClassName;
    }

    public List<String> getItemCodes() {
        return itemCodes;
    }

    public void setItemCodes(List<String> itemCodes) {
        this.itemCodes = itemCodes;
    }
}
