package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpPhysicalTrayReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* PCP物料仓库托盘数列表服务接口
*
* @author yuangui
* @since 2022-05-23
*/
@Api(tags = {"PCP物料仓库托盘数列表服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-IPcpPhysicalTrayApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/pcpPhysicalTray",
    url = "${yundt.cube.center.item.api:}"
)
public interface IPcpPhysicalTrayApi {

/**
* 新增PCP物料仓库托盘数列表
*
* @param addReqDto PCP物料仓库托盘数列表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增PCP物料仓库托盘数列表", notes = "新增PCP物料仓库托盘数列表")
RestResponse<Long> addPcpPhysicalTray(@RequestBody PcpPhysicalTrayReqDto addReqDto);

    /**
    * 修改PCP物料仓库托盘数列表
    *
    * @param modifyReqDto PCP物料仓库托盘数列表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改PCP物料仓库托盘数列表", notes = "修改PCP物料仓库托盘数列表")
    RestResponse<Void> modifyPcpPhysicalTray(@RequestBody PcpPhysicalTrayReqDto modifyReqDto);

    /**
    * 删除PCP物料仓库托盘数列表
    *
    * @param ids        PCP物料仓库托盘数列表删除数据ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除PCP物料仓库托盘数列表", notes = "删除PCP物料仓库托盘数列表")
    RestResponse<Void> removePcpPhysicalTray(@PathVariable("ids") String ids);

    @PostMapping("updateTrayNum")
    @ApiOperation(value = "修改PCP物料仓库托盘数列表", notes = "修改PCP物料仓库托盘数列表")
    RestResponse<Void> updateTrayNum(@RequestBody PcpPhysicalTrayReqDto modifyReqDto);
}
