/**
 * @(#)ShelfTaskDto 1.0 2019/2/28
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author shuangqing 2019/2/28
 */
@ApiModel(value = "ShelfTaskUpdateReqDto", description = "商品定时计划更新dto")
public class ShelfTaskUpdateReqDto extends BaseRespDto {

    @ApiModelProperty(name = "id", value = "主键id，必填")
    private Long id;

    @ApiModelProperty(name = "sellerId", value = "商户id，选填")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺id，选填")
    private Long shopId;

    @ApiModelProperty(name = "dirId", value = "目录id，选填")
    private Long dirId;

    @NotNull
    @ApiModelProperty(name = "itemId", value = "商品id，必填")
    private Long itemId;

    @NotNull
    @ApiModelProperty(name = "skuId", value = "skuId，必填")
    private Long skuId;

    @ApiModelProperty(name = "shelfTime", value = "上架时间，选填")
    private Date shelfTime;

    @ApiModelProperty(name = "allowOrderTime", value = "允许下单时间范围，选填")
    private String allowOrderTime;

    @ApiModelProperty(name = "type", value = "on:上架 off:下架，选填")
    private String type;

    @ApiModelProperty(name = "instanceId", value = "应用实例ID，必填")
    private Long instanceId;

    @ApiModelProperty(name = "tenantId", value = "租户id，必填")
    private Long tenantId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Date getShelfTime() {
        return shelfTime;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    public String getAllowOrderTime() {
        return allowOrderTime;
    }

    public void setAllowOrderTime(String allowOrderTime) {
        this.allowOrderTime = allowOrderTime;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
