/*
 * @(#)ItemSkuRelRespDto.java 1.0 2022年05月05日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>Title:ItemSkuRelRespDto</p>
 * <p>Description: </p>
 *
 * @author 顼阳
 * @date ${DATE} ${TIME}
 * @since 0.1.0
 */
@ApiModel(value = "ItemSkuRelRespDto", description = "商品响应Dto")
@Data
public class ItemSkuRelRespDto implements Serializable {

    private static final long serialVersionUID = 8959246011010585529L;

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    @ApiModelProperty(name = "skuId", value = "商品SKU ID")
    private Long skuId;
    @ApiModelProperty(name = "code", value = "编码")
    private String code;
    @ApiModelProperty(name = "longCode", value = "长编码")
    private String longCode;
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    //新增属性
    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "itemOrgId", value = "item组织id")
    private Long itemOrgId;

    @ApiModelProperty(name = "giftBox", value = "是否礼盒（0：是、1：否）")
    private Integer giftBox;

    @ApiModelProperty(name = "skuAttr", value = "sku属性")
    private String skuAttr;

    @ApiModelProperty(name = "itemBrand", value = "品牌")
    private String itemBrand;
}
