/*
 * @(#)ItemAuthLimitDto.java 1.0 2021/10/11
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import cn.hutool.core.collection.ListUtil;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

/**
 * 商品授权限制
 * @author 惜笔 | 林五弟
 * @version 1.0.0
 * @date 2021/10/11 17:56
 */
public class ItemAuthLimitDto {

    @ApiModelProperty(name = "businessType" , value = "业务类型（CATEGORY：类目、BRAND：品牌、SKU：商品sku、BANSKU：禁止的商品sku）")
    private String businessType;

    @ApiModelProperty(name = "targetType" , value = "目标类型，1-客户，2-店铺")
    private Integer targetType;

    @ApiModelProperty(name = "targetIdList" , value = "目标id(根据target_type)，如客户id，店铺id")
    private List<Long> targetIdList;

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Integer getTargetType() {
        return targetType;
    }

    public void setTargetType(Integer targetType) {
        this.targetType = targetType;
    }

    public List<Long> getTargetIdList() {
        return targetIdList;
    }

    public void setTargetIdList(List<Long> targetIdList) {
        this.targetIdList = targetIdList;
    }

    public void addTargetId(Long targetId) {
        if (Objects.isNull(this.targetIdList)){
            this.targetIdList = ListUtil.toList();
        }
        this.targetIdList.add(targetId);
    }
}
