/*
 * @(#)ItemSkuReqDto.java 1.0 2018-09-03
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request.dg;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * sku查询
 * @author  惜笔 | 林五弟
 * @date  2021/11/18 17:23
 * @version 1.0.0
 */
@Data
@ApiModel(value = "ItemExchangeUnitDgReqDto", description = "单位换算信息入参dto")
public class ItemExchangeUnitDgReqDto extends BaseVo {

    @NotNull(message = "skuCode不可为空")
    @ApiModelProperty(name = "skuCode", value = "skuCode")
    private String skuCode;

    @NotNull(message = "当前单位不可为空")
    @ApiModelProperty(name = "currentUnit", value = "当前单位")
    private String currentUnit;

    @NotNull(message = "当前单位数量不可为空")
    @ApiModelProperty(name = "currentNum", value = "当前单位数量")
    private Integer currentNum;

    //@NotNull(message = "目标单位不可为空")
//    @ApiModelProperty(name = "targetUnit", value = "目标单位不可为空")
//    private String targetUnit;


}
