package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 商品价格响应Dto
 *
 * @author 简树 零星
 * @since 2.0.0
 */
@ApiModel(value = "ItemPriceRespDto", description = "商品价格响应Dto")
public class ItemPriceRespDto extends BaseRespDto {

    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    /**
     * 价格名称
     */
    @ApiModelProperty(name = "name", value = "价格名称")
    private String name;
    /**
     * 币种
     */
    @ApiModelProperty(name = "currency", value = "币种")
    private String currency;
    /**
     * 价格
     */
    @ApiModelProperty(name = "price", value = "价格")
    private BigDecimal price;
    /**
     * 消耗积分
     */
    @ApiModelProperty(name = "points", value = "消耗积分")
    private Long points;
    /**
     * 价格体系
     */
    @ApiModelProperty(name = "priceType", value = "价格体系")
    private String priceType;
    /**
     * 是否激活 0不激活 1 激活
     */
    @ApiModelProperty(name = "isActived", value = "是否激活")
    private Integer isActived;
    /**
     * 商品 skuId
     */
    @ApiModelProperty(name = "skuId", value = "商品 skuId")
    private Long skuId;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getPoints() {
        return points;
    }

    public void setPoints(Long points) {
        this.points = points;
    }

    public String getPriceGroup() {
        return priceType;
    }

    public void setPriceGroup(String priceGroup) {
        this.priceType = priceGroup;
    }

    public Integer getIsActived() {
        return isActived;
    }

    public void setIsActived(Integer isActived) {
        this.isActived = isActived;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getPriceType() {
        return priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }
}
