package com.dtyunxi.yundt.cube.center.item.api.base.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author yufan
 * @time 2020/10/15 11:03
 */
@Api(tags = {"商品中心：单位查询服务接口"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-query-IUnitQueryApi",
        path = "/v1/unit",
        url = "${yundt.cube.center.item.api:}")
public interface IUnitQueryApi {

    /**
     * 根据ID主键查询
     *
     * @param id 主键
     * @return RestResponse<UnitReqDto>
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "根据Id查询单位信息", notes = "根据Id查询单位信息 \t\n id:单位Id")
    RestResponse<UnitRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 分页查询单位列表 filter -> UnitReqDto
     *
     * @param filter   查询参数unitDto json对象字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return RestResponse<PageInfoRequestUnitDto>>
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询单位分页列表", notes = "根据pageNum,pageSize,单位Dto查询单位信息,filter=UnitReqDto")
    RestResponse<PageInfo<UnitRespDto>> queryByPage(@RequestParam(name = "filter", required = false) String filter,
                                                    @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                    @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询单位列表 filter -> UnitReqDto
     *
     * @param filter   查询参数unitDto json对象字符串
     * @return RestResponse<PageInfoRequestUnitDto>>
     */
    @GetMapping(value = "/list")
    @ApiOperation(value = "查询单位列表", notes = "根据单位Dto查询单位信息,filter=UnitReqDto")
    RestResponse<List<UnitRespDto>> queryList(@RequestParam(name = "filter", required = false) String filter);


    /**
     * 根据单位类型查询单位
     *
     * @param type 单位类型
     * @return 单位列表
     */
    @GetMapping(value = "/get-by-type/{type}")
    @ApiOperation(value = "根据单位类型查询单位", notes = "根据单位类型查询单位")
    RestResponse<List<UnitRespDto>> queryByType(@PathVariable("type") String type);

    /**
     * 查询单位类型
     *
     * @return 单位类型列表
     */
    @GetMapping(value = "/type/list")
    @ApiOperation(value = "查询单位类型", notes = "查询单位类型")
    RestResponse<List<Map<String, String>>> queryUnitType();

    /**
     * 根据单位id列表批量查询单位
     *
     * @param unitIds 单位id列表
     * @return 单位列表
     * @author xuhuaqiang
     */
    @GetMapping(value = "/ids")
    @ApiOperation(value = "根据单位id列表批量查询单位", notes="批量查询，多个逗号隔开")
    RestResponse<List<UnitRespDto>> queryByIds(@RequestParam("unitIds") String unitIds);


    @GetMapping(value = "/code/{code}")
    @ApiOperation(value = "根据编码查询单位信息", notes = "根据编码查询单位信息 \t\n code:单位编码")
    RestResponse<UnitRespDto> queryByCode(@PathVariable("code") String code);
}
