package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <p>Title:ItemPlatformReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun
 * @date 2021/8/27 9:58
 * @since 0.1.0
 */
@ApiModel(value = "ItemPlatformReqDto", description = "商品允销平台关系Dto对象")
public class ItemPlatformReqDto extends BaseRespDto {


    @ApiModelProperty(name = "id", value = "")
    private Long id;

    @ApiModelProperty(name = "shelfId", value = "上架Id")
    private Long shelfId;

    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    @NotNull(message = "商品ID不能为空")
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    /**
     *  商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    @NotNull(message = "商品编码不能为空")
    private String itemCode;

    /**
     * 商品允销平台关系List
     */
    @ApiModelProperty(name = "channelReqDtoList", value = "商品允销平台关系List")
    private List<ItemChannelReqDto> channelReqDtoList;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public List<ItemChannelReqDto> getChannelReqDtoList() {
        return channelReqDtoList;
    }

    public void setChannelReqDtoList(List<ItemChannelReqDto> channelReqDtoList) {
        this.channelReqDtoList = channelReqDtoList;
    }

    public Long getShelfId() {
        return shelfId;
    }

    public void setShelfId(Long shelfId) {
        this.shelfId = shelfId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }
}
