package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.dto.BaseRespDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
* 货品Eo对象
*
* @author yuangui
* @since 2022-05-23
*/
@Data
@ApiModel(value = "PcpItemRespDto", description = "货品Eo对象")
public class PcpItemRespDto extends BaseRespDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
    *  分组ID
    */
    @ApiModelProperty(name = "groupId", value = "分组ID")
    private Long groupId;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品长编码")
    private String itemCode;
    /**
    *  编码
    */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;
    /**
    *  商品货号
    */
    @ApiModelProperty(name = "artNo", value = "商品货号")
    private String artNo;
    /**
    *  商品条码
    */
    @ApiModelProperty(name = "barCode", value = "商品条码")
    private String barCode;
    /**
    *  是否串码管理
    */
    @ApiModelProperty(name = "imeiCodeFlag", value = "是否串码管理")
    private String imeiCodeFlag;
    /**
    *  1-有效 0-无效
    */
    @ApiModelProperty(name = "itemStatus", value = "1-有效 0-无效")
    private Long itemStatus;
    /**
    *  商品剂型 1-粉剂
     *  todo 类型变更，从Long（北鼎华帝）改成String（汤臣妙可），需确保北鼎华帝数据库这个值为空
    */
    @ApiModelProperty(name = "itemDrug", value = "商品剂型 1-粉剂")
    private String itemDrug;
    /**
    *  标准批文
    */
    @ApiModelProperty(name = "standardApproval", value = "标准批文")
    private String standardApproval;
    /**
    *  旧批文
    */
    @ApiModelProperty(name = "oldApproval", value = "旧批文")
    private String oldApproval;
    /**
    *  1-产品 2-赠品 3-促销物料
    */
    @ApiModelProperty(name = "itemType", value = "1-产品 2-赠品 3-促销物料")
    private Long itemType;
    /**
    *  名称
    */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;
    /**
    *  单位
    */
    @ApiModelProperty(name = "unit", value = "单位")
    private String unit;
    /**
    *  NC单位ID
     *  todo 类型变更，从Long(北鼎华帝)改成String(汤臣妙可)，需确保北鼎华帝数据库这个值为空
    */
    @ApiModelProperty(name = "unitId", value = "NC单位ID")
    private String unitId;
    /**
    *  建议零售价
    */
    @ApiModelProperty(name = "recommendPrice", value = "建议零售价")
    private BigDecimal recommendPrice;
    /**
    *  品牌编码
    */
    @ApiModelProperty(name = "brandCode", value = "品牌编码")
    private String brandCode;
    /**
    *  品牌名称
    */
    @ApiModelProperty(name = "brandName", value = "品牌名称")
    private String brandName;
    /**
    *  产地
    */
    @ApiModelProperty(name = "placeOfOrigin", value = "产地")
    private String placeOfOrigin;
    /**
    *  线下安全库存
    */
    @ApiModelProperty(name = "offlineSafetyStock", value = "线下安全库存")
    private BigDecimal offlineSafetyStock;
    /**
    *  安全库存策略，0-关闭，1-开启
    */
    @ApiModelProperty(name = "safetyStockStrategy", value = "安全库存策略，0-关闭，1-开启")
    private Integer safetyStockStrategy;
    /**
    *  是否线下可售，0-否，1-是
    */
    @ApiModelProperty(name = "ifAvailableOffline", value = "是否线下可售，0-否，1-是")
    private Integer ifAvailableOffline;
    /**
    *  防超卖库存数
    */
    @ApiModelProperty(name = "avoidOversoldInventory", value = "防超卖库存数")
    private BigDecimal avoidOversoldInventory;
    /**
    *  单渠道共享数
    */
    @ApiModelProperty(name = "singleChannelShare", value = "单渠道共享数")
    private BigDecimal singleChannelShare;
    /**
    *  单渠道共享指定店铺
    */
    @ApiModelProperty(name = "singleChannelShopId", value = "单渠道共享指定店铺")
    private Long singleChannelShopId;
    /**
    *  库存检查配置
    */
    @ApiModelProperty(name = "checkConfigId", value = "库存检查配置")
    private Long checkConfigId;
    /**
    *  珠海仓托盘数量
    */
    @ApiModelProperty(name = "zhTrayNum", value = "珠海仓托盘数量")
    private Long zhTrayNum;
    /**
    *  拆包配置
    */
    @ApiModelProperty(name = "packageSplitId", value = "拆包配置")
    private Long packageSplitId;
    /**
    *  重量
    */
    @ApiModelProperty(name = "quantity", value = "重量")
    private BigDecimal quantity;
    /**
    *  大包系数
    */
    @ApiModelProperty(name = "bigRatio", value = "大包系数")
    private Long bigRatio;
    /**
    *  中包系数
    */
    @ApiModelProperty(name = "middleRatio", value = "中包系数")
    private Long middleRatio;
    /**
    *  小包系数
    */
    @ApiModelProperty(name = "smallRatio", value = "小包系数")
    private Long smallRatio;
    /**
    *  防伪码
    */
    @ApiModelProperty(name = "securityCode", value = "防伪码")
    private String securityCode;
    /**
    *  保质期单位
    */
    @ApiModelProperty(name = "expirationUnit", value = "保质期单位")
    private String expirationUnit;
    /**
    *  保质期
    */
    @ApiModelProperty(name = "expirationDate", value = "保质期")
    private String expirationDate;
    /**
    *  是否免检
    */
    @ApiModelProperty(name = "exemption", value = "是否免检")
    private String exemption;
    /**
    *  体积
    */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;
    /**
    *  长
    */
    @ApiModelProperty(name = "length", value = "长")
    private BigDecimal length;
    /**
    *  宽
    */
    @ApiModelProperty(name = "width", value = "宽")
    private BigDecimal width;
    /**
    *  高
    */
    @ApiModelProperty(name = "height", value = "高")
    private BigDecimal height;
    /**
    *  长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "lengthUnit", value = "长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String lengthUnit;
    /**
    *  高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "heightUnit", value = "高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String heightUnit;
    /**
    *  宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "widthUnit", value = "宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String widthUnit;
    /**
    *  重量单位
    */
    @ApiModelProperty(name = "quantityUnit", value = "重量单位")
    private String quantityUnit;
    /**
    *  所属客户编码
    */
    @ApiModelProperty(name = "customerNo", value = "所属客户编码")
    private String customerNo;
    /**
    *  货品详情
    */
    @ApiModelProperty(name = "detail", value = "货品详情")
    private String detail;
    /**
    *  运费模板(面向运营)
    */
    @ApiModelProperty(name = "shippingTplId", value = "运费模板(面向运营)")
    private Long shippingTplId;
    /**
    *  增值税率
    */
    @ApiModelProperty(name = "taxRate", value = "增值税率")
    private Integer taxRate;
    /**
    *  毛重
    */
    @ApiModelProperty(name = "grossWeight", value = "毛重")
    private BigDecimal grossWeight;
    /**
    *  毛重单位
    */
    @ApiModelProperty(name = "grossWeightUnit", value = "毛重单位")
    private String grossWeightUnit;
    /**
    *  净重
    */
    @ApiModelProperty(name = "netWeight", value = "净重")
    private BigDecimal netWeight;
    /**
    *  净重单位
    */
    @ApiModelProperty(name = "netWeightUnit", value = "净重单位")
    private String netWeightUnit;
    /**
    *  规格
    */
    @ApiModelProperty(name = "specification", value = "规格")
    private String specification;
    private String cfproducers;
    private String dosageForm;

    /**
     *  索赔价格
     */
    @ApiModelProperty(name = "claimPrice", value = "索赔价格")
    private BigDecimal claimPrice;

    /**
     *  存储条件
     */
    @ApiModelProperty(name = "storageCondition", value = "存储条件")
    private String storageCondition;

    /**
     *  大包系数
     */
    @ApiModelProperty(name = "big_box")
    private Long bigBox;
    /**
     *  中包系数
     */
    @ApiModelProperty(name = "middle_box")
    private Long middleMax;
    /**
     *  小包系数
     */
    @ApiModelProperty(name = "small_box")
    private Long smallBox;
    /**
     *  体积单位
     */
    @ApiModelProperty(name = "volumnUnit", value = "体积单位")
    private String volumnUnit;
    /**
     *  商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "oldItemName", value = "旧名称")
    private String oldItemName;

    /**
     *  启用日期
     */
    @ApiModelProperty(name = "enableDate", value = "启用日期")
    private Date enableDate;

    /**
     *  停用日期
     */
    @ApiModelProperty(name = "disableDate", value = "停用日期")
    private Date disableDate;

    @ApiModelProperty(name = "e3ItemCode", value = "e3物料编码")
    private String e3ItemCode;

    @ApiModelProperty(name = "itemCreateTime", value = "ItemEo实体创建时间")
    @JSONField(
            format = "yyyy-MM-dd HH:mm:ss"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date itemCreateTime;
}
