/*
 * @(#)ItemDetailRespDto.java 1.0 2021年09月14日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Title:ItemDetailRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/14 22:09
 * @since 0.1.0
 */
@ApiModel(value = "BdItemDetailRespDto", description = "北鼎商品详情Dto对象")
public class BdItemDetailRespDto implements Serializable {

    @ApiModelProperty(name = "id", value = "商品ID")
    private Long id;
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    @ApiModelProperty(name = "dirIds", value = "后台类目数组")
    private List<String> dirIds;
    @ApiModelProperty(name = "dirId", value = "后台类目")
    private Long dirId;
    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;
    @ApiModelProperty(name = "dirPrefixIds", value = "前台类目数组")
    private List<String> dirPrefixIds;
    @ApiModelProperty(name = "dirPrefixId", value = "前台类目")
    private Long dirPrefixId;
    @ApiModelProperty(name = "dirPrefixName", value = "前台类目名称")
    private String dirPrefixName;
    @ApiModelProperty(name = "displayName", value = "显示名")
    private String displayName;
    @ApiModelProperty(name = "brief", value = "介绍")
    private String brief;
    @ApiModelProperty(name = "detail", value = "详情")
    private String detail;
    @ApiModelProperty(name = "enCode", value = "EN（69码）")
    private String enCode;
    @ApiModelProperty(name = "status", value = "状态(0已发布 1上架 2下架 3未发布 4禁用状态)")
    private Integer status;
    @ApiModelProperty(name = "type", value = "1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品")
    private Integer type;
    @ApiModelProperty(name = "domesticB2b", value = "国内B2B卖点")
    private String domesticB2b;
    @ApiModelProperty(name = "internalB2b", value = "国外B2B卖点")
    private String internalB2b;
    @ApiModelProperty(name = "principalPerson", value = "产品负责人")
    private String principalPerson;
    @ApiModelProperty(name = "prodLargeCode", value = "产品大类编码(北鼎一级品类)")
    private String prodLargeCode;
    @ApiModelProperty(name = "prodLargeClass", value = "产品大类(北鼎一级品类描述)")
    private String prodLargeClass;
    @ApiModelProperty(name = "prodSecCode", value = "产品二级分类编码(北鼎二级品类)")
    private String prodSecCode;
    @ApiModelProperty(name = "prodSecClassify", value = "产品二级分类(北鼎二级品类描述)")
    private String prodSecClassify;
    @ApiModelProperty(name = "prodThrCode", value = "产品三级分类编码(北鼎三级品类)")
    private String prodThrCode;
    @ApiModelProperty(name = "prodThrClassify", value = "产品三级分类(北鼎三级品类描述)")
    private String prodThrClassify;
    @ApiModelProperty(name = "prodClassCode", value = "产品型号")
    private String prodClassCode;
    @ApiModelProperty(name = "prodClassName", value = "产品名称")
    private String prodClassName;
    @ApiModelProperty(name = "accountingCategoryCode", value = "北鼎核算品类")
    private String accountingCategoryCode;
    @ApiModelProperty(name = "accountingCategoryName", value = "北鼎核算品类描述")
    private String accountingCategoryName;
    @ApiModelProperty(name = "specContent", value = "规格")
    private String specContent;
    @ApiModelProperty(name = "medias", value = "商品多媒体")
    private List<ItemMediasRespDto> medias = Lists.newArrayList();
    @ApiModelProperty(name = "skuExtRespDtos", value = "sku信息")
    private List<ItemSkuRespDto> skuExtRespDtos;
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    @ApiModelProperty(name = "price", value = "商品价格")
    private String price;
    @ApiModelProperty(name = "barCode", value = "条形码")
    private String barCode;
    /*是否虚拟商品,0-否,1-是*/
    @ApiModelProperty(name = "vitrual", value = " 是否虚拟商品,0-否,1-是")
    private String vitrual ;


    public String getVitrual() {
        return vitrual;
    }
    public void setVitrual(String vitrual) {
        this.vitrual = vitrual;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Long getDirPrefixId() {
        return dirPrefixId;
    }

    public void setDirPrefixId(Long dirPrefixId) {
        this.dirPrefixId = dirPrefixId;
    }

    public String getDirPrefixName() {
        return dirPrefixName;
    }

    public void setDirPrefixName(String dirPrefixName) {
        this.dirPrefixName = dirPrefixName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDomesticB2b() {
        return domesticB2b;
    }

    public void setDomesticB2b(String domesticB2b) {
        this.domesticB2b = domesticB2b;
    }

    public String getInternalB2b() {
        return internalB2b;
    }

    public void setInternalB2b(String internalB2b) {
        this.internalB2b = internalB2b;
    }

    public String getPrincipalPerson() {
        return principalPerson;
    }

    public void setPrincipalPerson(String principalPerson) {
        this.principalPerson = principalPerson;
    }

    public String getProdLargeClass() {
        return prodLargeClass;
    }

    public void setProdLargeClass(String prodLargeClass) {
        this.prodLargeClass = prodLargeClass;
    }

    public String getProdSecClassify() {
        return prodSecClassify;
    }

    public void setProdSecClassify(String prodSecClassify) {
        this.prodSecClassify = prodSecClassify;
    }

    public String getSpecContent() {
        return specContent;
    }

    public void setSpecContent(String specContent) {
        this.specContent = specContent;
    }

    public List<ItemMediasRespDto> getMedias() {
        return medias;
    }

    public void setMedias(List<ItemMediasRespDto> medias) {
        this.medias = medias;
    }

    public List<ItemSkuRespDto> getSkuExtRespDtos() {
        return skuExtRespDtos;
    }

    public void setSkuExtRespDtos(List<ItemSkuRespDto> skuExtRespDtos) {
        this.skuExtRespDtos = skuExtRespDtos;
    }

    public String getEnCode() {
        return enCode;
    }

    public void setEnCode(String enCode) {
        this.enCode = enCode;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public List<String> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<String> dirIds) {
        this.dirIds = dirIds;
    }

    public List<String> getDirPrefixIds() {
        return dirPrefixIds;
    }

    public void setDirPrefixIds(List<String> dirPrefixIds) {
        this.dirPrefixIds = dirPrefixIds;
    }

    public String getProdLargeCode() {
        return prodLargeCode;
    }

    public void setProdLargeCode(String prodLargeCode) {
        this.prodLargeCode = prodLargeCode;
    }

    public String getProdSecCode() {
        return prodSecCode;
    }

    public void setProdSecCode(String prodSecCode) {
        this.prodSecCode = prodSecCode;
    }

    public String getProdThrCode() {
        return prodThrCode;
    }

    public void setProdThrCode(String prodThrCode) {
        this.prodThrCode = prodThrCode;
    }

    public String getProdThrClassify() {
        return prodThrClassify;
    }

    public void setProdThrClassify(String prodThrClassify) {
        this.prodThrClassify = prodThrClassify;
    }

    public String getProdClassCode() {
        return prodClassCode;
    }

    public void setProdClassCode(String prodClassCode) {
        this.prodClassCode = prodClassCode;
    }

    public String getProdClassName() {
        return prodClassName;
    }

    public void setProdClassName(String prodClassName) {
        this.prodClassName = prodClassName;
    }

    public String getAccountingCategoryCode() {
        return accountingCategoryCode;
    }

    public void setAccountingCategoryCode(String accountingCategoryCode) {
        this.accountingCategoryCode = accountingCategoryCode;
    }

    public String getAccountingCategoryName() {
        return accountingCategoryName;
    }

    public void setAccountingCategoryName(String accountingCategoryName) {
        this.accountingCategoryName = accountingCategoryName;
    }
}
