package com.dtyunxi.yundt.cube.center.item.api.common.enums;

/**
 * <p>Title:ItemExtExceptionCode</p>
 * <p>Description: </p>
 *
 * @author yiyun
 * @date 2021/8/27 14:36
 * @since 0.1.0
 */
public enum ItemExtExceptionCode {
    ITEM_ID_NOT_EXIST("10001", "商品ID不能为空"),
    ITEM_DATA_NOT_EXIST("10002", "商品信息不存在"),
    SKU_ID_NOT_EXIST("10003", "skuId不能为空"),
    ITEM_EMPOWER_TO_OA_FAIL("10005", "商品授权客户发送OA审核失败"),
    CUSTOMER_ID_NOT_EXIST("10006", "客户id不能为空"),
    CUSTOMER_CODE_NOT_EXIST("10007", "客户编码不能为空"),
    ITEM_NOT_EXIST("10008", "商品信息不能为空"),
    NOT_OFF_SHEL_ITEM("10009", "没有需要下架的商品"),
    NOT_ON_SHEL_ITEM("10010", "没有需要上架的商品"),
    ITEM_CUSTOMER_ID_NOT_EXIST("10011", "商品id和客户id不能同时为空"),
    ITEM_CODE_NOT_EXIST("10012", "商品编码不存在"),
    ITEM_CODE_IS_EXIST("10012", "商品编码已存在"),
    ITEM_OR_CUSTOMER_DATA("10013", "商品数据或者客户数据不存在"),
    SKU_DATA_NOT_EXIST("10014", "skuId信息不存在"),
    ITEM_ON_SHELF_NOT_EXIST("10015", "上架信息不能为空"),
    RELATION_COLLECT_NOT_EXIST("10016", "找不到对应的集合信息"),
    ITEM_RELATION_IMPORT_PARSING_ERROR("10017","商品映射导入文件解析错误"),
    ITEM_RELATION_IMPORT_ERROR("10018","商品映射导入文件没有数据"),
    IMPORT_RELATION_NAME_REPEAT("10019", "导入的物料编码有重复,请检查！"),
    ITEM_NOT_BUNDLE_EXIST("10020", "组合商品信息不能为空"),
    ITEM_NOT_SHELF_EXIST("10021", "上架信息不存在，无法删除"),
    ITEM_NOT_MOVE_UP("10022", "首条数据无法上移"),
    ITEM_NOT_MOVE_DOWN("10023", "尾数据无法下移"),
    METHOD_PARAM_EMPTY("1007", "方法入参为空"),
    ITEM_NUM_ERROR("1008", "商品数量异常"),
    UPDATE_DELIVERY_ITEM_NUM_ERROR("1009", "商品数量异常"),
    ITEM_DIR_PARENT_NOT_EXIST("10024", "类目父级ID为空"),
    ITEM_DIR_COLLECTION_NOT_EXIST("10025", "类目集合为空"),
    ITEM_BUNDLES_IMPORT_PARSING_ERROR("10026", "组合商品导入文件解析错误"),
    ITEM_BUNDLES_IMPORT_ERROR("10027","组合商品导入文件没有数据"),
    ITEM_PLATFORM_IMPORT_PARSING_ERROR("10029","商品允销平台关系导入解析错误"),
    ITEM_DIR_NOT_EMPTY_ERROR("10028","前台类目和后台类目不能为空!"),
    QUERY_ITEM_PRICE_FAIL("10030", "查询商品价格出错"),
    CUSTOMER_DATA_NOT_EXIST("10013", "客户信息不存在"),
    VIR_STORAGE_ROLLBACK_FAIL("10031", "虚拟库存回滚失败"),
    CURRENCY_NOT_EXIST("10032", "国外价格设置币种不能为空"),
    STATISTICS_OVER_COUNT("10032", "可配置总数量最多50个，请返回修改"),
    STATISTICS_ITEM_COUNT("10032", "推荐商品总数量最多50个"),
    EMPOWER_IMPORT_PARSING_ERROR("300030", "允销导入文件解析失败"),
    ITEM_EMPOWER_PLATFORM_NULL("300016", "商品还没有授权平台"),
    CUSTOMER_ITEM_EMPOWER_PLATFORM_NULL("300017", "客户和商品授权平台没有相同的"),
    IMPORT_ITEM_CODE_REPEAT("30035", "商品与客户已经授权的商品重复"),
    ITEM_MEDIAS_PATH_EMPTY("30036", "商品文件地址为空"),
    ITEM_MEDIAS_TYPE_EMPTY("30037", "商品文件类型为空"),
    ;


    private final String code;
    private final String msg;

    ItemExtExceptionCode(String code, String msg) {
        this.code = code;
        this.msg = msg;

    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }
}
