/*
 * @(#)ItemEffectiveReqDto.java 1.0 2021年12月30日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * <p>Title:ItemEffectiveReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/12/30 2:11
 * @since 0.1.0
 */
@ApiModel(value = "ItemEffectiveReqDto", description = "ItemEffectiveReqDto对象")
public class ItemEffectiveReqDto {

    @ApiModelProperty(value = "商品Id集合")
    private List<Long> itemIds;
    @ApiModelProperty(value = "客户编码")
    private String customerCode;
    @ApiModelProperty(value = "客户Id")
    private Long customerId;
    @ApiModelProperty(value = "客户类型：0：正常客户，1：二类机客户")
    private Integer customerType;
    @ApiModelProperty(value = "下单类型：代客下单 经销商下单")
    private Integer placeType;
    @ApiModelProperty(name = "priceIdentify", value = "价格标识(0:国内价格标识,1:国外价格标识)")
    private String priceIdentify;
    @ApiModelProperty(value = "页码")
    private Integer pageNum;
    @ApiModelProperty(value = "条数")
    private Integer pageSize;
    @ApiModelProperty(name = "currency", value = "币种,0:人民币 1:美元 2:日元 3:欧元 4:英镑 5:澳元 6:港元 7:澳门元")
    private Integer currency;
    @ApiModelProperty(name = "shelfAddress", value = "上架地址(0:国内B2B商城,1:国外B2B商城)")
    private String shelfAddress;

    public List<Long> getItemIds() {
        return itemIds;
    }

    public void setItemIds(List<Long> itemIds) {
        this.itemIds = itemIds;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public Integer getCustomerType() {
        return customerType;
    }

    public void setCustomerType(Integer customerType) {
        this.customerType = customerType;
    }

    public Integer getPlaceType() {
        return placeType;
    }

    public void setPlaceType(Integer placeType) {
        this.placeType = placeType;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getPriceIdentify() {
        return priceIdentify;
    }

    public void setPriceIdentify(String priceIdentify) {
        this.priceIdentify = priceIdentify;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getCurrency() {
        return currency;
    }

    public void setCurrency(Integer currency) {
        this.currency = currency;
    }

    public String getShelfAddress() {
        return shelfAddress;
    }

    public void setShelfAddress(String shelfAddress) {
        this.shelfAddress = shelfAddress;
    }
}
