/*
 * @(#)ItemRelationQueryConditionReqDto.java 1.0 2021年09月15日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Title:ItemRelationQueryConditionReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/15 11:09
 * @since 0.1.0
 */
@ApiModel(value = "ItemRelationQueryConditionReqDto", description = "商品对照查询条件dto")
@Data
public class ItemRelationQueryConditionReqDto implements Serializable {

    @ApiModelProperty(name = "channelItemCode", value = "平台商品编码")
    private String channelItemCode;
    @ApiModelProperty(name = "channelItemName", value = "平台商品名称")
    private String channelItemName;

    @ApiModelProperty(name = "code", value = "物料编码")
    private String code;
    @ApiModelProperty(name = "name", value = "物料名称")
    private String name;

    @ApiModelProperty(name = "channelSkuId", value = "平台skuID")
    private String channelSkuId;

    @ApiModelProperty(name = "channelSkuCode", value = "平台sku编码")
    private String channelSkuCode;

    @ApiModelProperty(name = "relationState", value = "关联状态：YES：已关联；NO：未关联")
    private String relationState;

    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    private String shopCode;

    @ApiModelProperty(name = "itemType", value = "商品类型：1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品")
    private String itemType;

    @ApiModelProperty(name = "giftFlag", value = "是否赠品：1：是，0否")
    private String giftFlag;


    @ApiModelProperty(name = "channelCode", value = "关联平台编码")
    private String channelCode;

    @ApiModelProperty(name = "platformId", value = "关联平台")
    private String platformId;
    @ApiModelProperty(name = "platformName", value = "关联平台名称")
    private String platformName;

    @ApiModelProperty(name = "shopId", value = "所属店铺ID")
    private String shopId;
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    @ApiModelProperty(name = "shopCodes", value = "店铺列表List")
    private List<String> shopCodes;

    @ApiModelProperty(name = "skuId", value = "SKUID")
    private String skuId;

    @ApiModelProperty(
            name = "pageNum",
            value = "当前页"
    )
    private Integer pageNum;
    @ApiModelProperty(
            name = "pageSize",
            value = "每页数"
    )
    private Integer pageSize;

    @ApiModelProperty(name = "prodLargeClass", value = "产品大类(北鼎一级品类描述)")
    private String prodLargeClass;
    @ApiModelProperty(name = "prodLargeCode", value = "产品大类编码(北鼎一级品类)")
    private String prodLargeCode;
    @ApiModelProperty(name = "prodSecClassify", value = "产品二级分类(北鼎二级品类描述)")
    private String prodSecClassify;
    @ApiModelProperty(name = "prodSecCode", value = "产品二级分类编码(北鼎二级品类)")
    private String prodSecCode;
    @ApiModelProperty(name = "prodThrClassify", value = "产品三级分类(北鼎三级品类描述)")
    private String prodThrClassify;
    @ApiModelProperty(name = "prodThrCode", value = "产品三级分类编码(北鼎三级品类)")
    private String prodThrCode;
    @ApiModelProperty(name = "prodClassCode", value = "产品型号")
    private String prodClassCode;
    @ApiModelProperty(name = "prodClassName", value = "产品名称")
    private String prodClassName;

}
