package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemInfoSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemUnitConversionQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemInfoSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemUnitConversionRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 商品规格换算表服务接口
*
* @author author
* @since 2022-08-28
*/
@Api(tags = {"商品规格换算表服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemUnitConversion",
        url = "${yundt.cube.center.item.api:}")
public interface IItemUnitConversionQueryApi {

    /**
    * 根据id查询商品规格换算表
    *
    * @param id 商品规格换算表id
    * @return   商品规格换算表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询商品规格换算表", notes = "根据id查询商品规格换算表")
    RestResponse<ItemUnitConversionRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 商品规格换算表分页数据
    *
    * @param filter   商品规格换算表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 商品规格换算表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "商品规格换算表分页数据", notes = "根据filter查询条件查询商品规格换算表数据，filter=ItemUnitConversionReqDto")
    RestResponse<PageInfo<ItemUnitConversionRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    @PostMapping("/page")
    @ApiOperation(value = "商品规格换算表分页数据", notes = "根据filter查询条件查询商品规格换算表数据，filter=ItemUnitConversionReqDto")
    RestResponse<PageInfo<ItemUnitConversionRespDto>> queryByPage(@RequestBody ItemUnitConversionQueryReqDto queryReqDto);

    /**
     * 根据商品id查询
     * @param id
     * @return
     */
    @GetMapping("/itemUnit/{id}")
    @ApiOperation(value = "根据id查询商品规格换算表", notes = "根据id查询商品规格换算表")
    RestResponse<List<ItemUnitConversionRespDto>> queryItemUnitById(@PathVariable("id") Long id);

    /**
     * 根据商品code查询
     * @param code
     * @return
     */
    @GetMapping("/goodsUnit/{code}")
    @ApiOperation(value = "根据id查询商品规格换算表", notes = "根据id查询商品规格换算表")
    RestResponse<List<ItemUnitConversionRespDto>> queryItemUnitByCode(@PathVariable("code") String code);

    /**
     * 根据商品code查询 基本->拿cv
     * @param code
     * @return
     */
    @PostMapping("/goodsUnitList")
    @ApiOperation(value = "根据商品编码查询", notes = "根据id查询商品规格换算表")
    RestResponse<List<ItemUnitConversionRespDto>> queryItemUnitByCodeList(@RequestBody  List<String> codeList);

    /**
     * 查询商品规格
     * @param itemInfoSkuReqDto
     * @return
     */
    @PostMapping(value = "/queryItemSkuByCode", produces = "application/json")
    @ApiOperation(value = "查询商品规格", notes = "查询商品规格")
    RestResponse<ItemInfoSkuRespDto> queryItemSkuByCode(@Validated @RequestBody ItemInfoSkuReqDto itemInfoSkuReqDto);
}
