/**
 * @(#)ItemListQueryReqDto.java 1.0 2019/10/16
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.yx.tcbj.center.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "ItemExportQueryReqDto", description = "商品列表导出查询请求dto")
public class ItemExportQueryReqDto extends RequestDto {

    @ApiModelProperty(name = "pageNum", value = "当前页")
    private Integer pageNum = 1;

    @ApiModelProperty(name = "pageSize", value = "每页显示数")
    private Integer pageSize = 10;

    @ApiModelProperty(name = "id", value = "唯一标识")
    private Long id;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemStatus", value = "商品上架状态： 1 已上架 2 已下架")
    private Integer itemStatus;

    @ApiModelProperty(name = "skuCode", value = "SKU编码")
    private String skuCode;

    @ApiModelProperty(name = "status", value = "商品状态：0草稿，1已上架 2已下架 3待审核，4待上架，6已售罄（查询类型，存在于数据库中）")
    private Integer status;

    @ApiModelProperty(name = "frontDirId", value = "前台类目")
    private Long frontDirId;

    @ApiModelProperty(name = "shopDirId", value = "店铺类目")
    private Long shopDirId;

    @ApiModelProperty(name = "sellerId", value = "商户id")
    private Long sellerId;

    @ApiModelProperty(name = "type",value = "类型：商品类型：1 普通商品；2 产品；3 组合商品  默认1, 4 虚拟商品")
    private Integer type;

    @ApiModelProperty(name = "shelfType", value = "上架类型：1 普通上架  2 周期购上架")
    private Integer shelfType;
    @ApiModelProperty(name = "itemType", value = "商品类型：1普通商品 2积分商品")
    private Integer itemType;

    @ApiModelProperty(name = "backDirId", value = "后台类目id")
    private Long backDirId;

    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购 2 积分商品 3 赠品商品 默认0")
    private Integer busType;

    @ApiModelProperty(name = "bizType", value = "系统业务类型，1-商城商品查询，2-商品库商品查询")
    private Integer bizType;

    @ApiModelProperty(name = "yearBegin", value = "所属年份（起始）")
    private Integer yearBegin;

    @ApiModelProperty(name = "yearEnd", value = "所属年份（结束）")
    private Integer yearEnd;

    @ApiModelProperty(name = "updateBeginTime", value = "更新开始时间")
    private String updateBeginTime;

    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间")
    private String updateEndTime;

    @ApiModelProperty(name = "sellOut", value = "是否售罄")
    private Boolean sellOut;

    @ApiModelProperty(name = "groupBy", value = "查询数据显示方式:1按店铺+商品；2商品，默认1")
    private Integer groupBy;

    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否")
    private Integer distribution;

    @ApiModelProperty(name = "bundle", value = "是否是组合商品: 1 是 0 否")
    private Integer bundle;

    @ApiModelProperty(name = "channel", value = "渠道类型（1：品牌方运营端，2：大B卖家端）")
    private Integer channel;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;

    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Integer getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(Integer itemStatus) {
        this.itemStatus = itemStatus;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getFrontDirId() {
        return frontDirId;
    }

    public void setFrontDirId(Long frontDirId) {
        this.frontDirId = frontDirId;
    }

    public Long getShopDirId() {
        return shopDirId;
    }

    public void setShopDirId(Long shopDirId) {
        this.shopDirId = shopDirId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getShelfType() {
        return shelfType;
    }

    public void setShelfType(Integer shelfType) {
        this.shelfType = shelfType;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Long getBackDirId() {
        return backDirId;
    }

    public void setBackDirId(Long backDirId) {
        this.backDirId = backDirId;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public Integer getYearBegin() {
        return yearBegin;
    }

    public void setYearBegin(Integer yearBegin) {
        this.yearBegin = yearBegin;
    }

    public Integer getYearEnd() {
        return yearEnd;
    }

    public void setYearEnd(Integer yearEnd) {
        this.yearEnd = yearEnd;
    }

    public String getUpdateBeginTime() {
        return updateBeginTime;
    }

    public void setUpdateBeginTime(String updateBeginTime) {
        this.updateBeginTime = updateBeginTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    public Boolean getSellOut() {
        return sellOut;
    }

    public void setSellOut(Boolean sellOut) {
        this.sellOut = sellOut;
    }

    public Integer getGroupBy() {
        return groupBy;
    }

    public void setGroupBy(Integer groupBy) {
        this.groupBy = groupBy;
    }

    public Integer getDistribution() {
        return distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }

    public Integer getBundle() {
        return bundle;
    }

    public void setBundle(Integer bundle) {
        this.bundle = bundle;
    }

    public Integer getChannel() {
        return channel;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }
}
