/**
 * @(#)ItemListVersion.java 1.0 2019/10/11
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.yx.tcbj.center.api.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 商品列表对象信息
 *
 * @author wu.sheng
 * @time 2019/10/11 11:36
 */
@ApiModel(value = "ItemListRespDto", description = "商品列表对象信息")
public class ItemExportQueryRespDto {

    @ApiModelProperty(name = "id", value = "版本id")
    private Long id;

    @ApiModelProperty(name = "version", value = "版本")
    private Long version;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "itemStatus", value = "商品上架状态： 1 已上架 2 已下架")
    private Integer itemStatus;

    @ApiModelProperty(name = "imgPath", value = "商品图片")
    private String imgPath;

    @ApiModelProperty(name = "maxSellPrice", value = "最高售价")
    private BigDecimal maxSellPrice;

    @ApiModelProperty(name = "maxSellPrice", value = "最低售价")
    private BigDecimal minSellPrice;

    @ApiModelProperty(name = "status", value = "商品状态：0草稿，1待审核，4待上架，5已上架，6已下架")
    private Integer status;

    @ApiModelProperty(name = "shelfType", value = "上架类型：1 普通上架  2 周期购上架")
    private Integer shelfType;
    @ApiModelProperty(name = "type", value = "商品类型:1普通商品 4虚拟商品")
    private Integer type;

    @ApiModelProperty(name = "createTime", value = "商品创建时间")
    private Date createTime;

    @ApiModelProperty(name = "itemTotalStorage", value = "商品总库存")
    private Long itemTotalStorage;
    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(name = "skus", value = "商品skus")
    private List<ItemSkuRespDto> skus;


    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购  默认0")
    private Integer busType;

    /**
     * 商户名称
     */
    @ApiModelProperty(name = "sellerName", value = "商户名称")
    private String sellerName;

    @ApiModelProperty(name = "brandId", value = "品牌ID")
    private Long brandId;

    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    @ApiModelProperty(name = "year", value = "所属年份")
    private Integer year;

    @ApiModelProperty(name = "dirId", value = "后台类目ID")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;

    @ApiModelProperty(name = "frontDirIdList", value = "前台类目Id")
    private List<Long> frontDirIdList;

    @ApiModelProperty(name = "frontDirNameList", value = "前台类目名称")
    private List<String> frontDirNameList;

    @ApiModelProperty(name = "isAfterSale", value = "是否售后：0否1是")
    private Integer isAfterSale;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "dirIdList", value = "后端类目id集合：[1级，2级，3级]形式")
    private List<Long> dirIdList;

    @ApiModelProperty(name = "dirNameList", value = "后端类目名称集合：[1级，2级，3级]形式")
    private List<String> dirNameList;

    @ApiModelProperty(name = "shopAuth", value = "商品sku是否已取消店铺授权：0否 1是")
    private Integer shopAuth;

    @ApiModelProperty(
            name = "giftBox",
            value = "是否礼盒（0：是、1：否）"
    )
    private Integer giftBox;

    @ApiModelProperty("建议零售价")
    private BigDecimal retailPrice;

    @ApiModelProperty("自定义零售价")
    private BigDecimal dealerRetailPrice;

    @ApiModelProperty("外部编码")
    private String externalCode;

    public Integer getShopAuth() {
        return shopAuth;
    }

    public void setShopAuth(Integer shopAuth) {
        this.shopAuth = shopAuth;
    }

    public List<Long> getDirIdList() {
        return dirIdList;
    }

    public void setDirIdList(List<Long> dirIdList) {
        this.dirIdList = dirIdList;
    }

    public List<String> getDirNameList() {
        return dirNameList;
    }

    public void setDirNameList(List<String> dirNameList) {
        this.dirNameList = dirNameList;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getIsAfterSale() {
        return isAfterSale;
    }

    public void setIsAfterSale(Integer isAfterSale) {
        this.isAfterSale = isAfterSale;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getImgPath() {
        return imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    public BigDecimal getMaxSellPrice() {
        return maxSellPrice;
    }

    public void setMaxSellPrice(BigDecimal maxSellPrice) {
        this.maxSellPrice = maxSellPrice;
    }

    public BigDecimal getMinSellPrice() {
        return minSellPrice;
    }

    public void setMinSellPrice(BigDecimal minSellPrice) {
        this.minSellPrice = minSellPrice;
    }

    public Long getItemTotalStorage() {
        return itemTotalStorage;
    }

    public void setItemTotalStorage(Long itemTotalStorage) {
        this.itemTotalStorage = itemTotalStorage;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getShelfType() {
        return shelfType;
    }

    public void setShelfType(Integer shelfType) {
        this.shelfType = shelfType;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<ItemSkuRespDto> getSkus() {
        return skus;
    }

    public void setSkus(List<ItemSkuRespDto> skus) {
        this.skus = skus;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Integer getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(Integer itemStatus) {
        this.itemStatus = itemStatus;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public List<Long> getFrontDirIdList() {
        return frontDirIdList;
    }

    public void setFrontDirIdList(List<Long> frontDirIdList) {
        this.frontDirIdList = frontDirIdList;
    }

    public List<String> getFrontDirNameList() {
        return frontDirNameList;
    }

    public void setFrontDirNameList(List<String> frontDirNameList) {
        this.frontDirNameList = frontDirNameList;
    }

    public Integer getGiftBox() {
        return giftBox;
    }

    public void setGiftBox(Integer giftBox) {
        this.giftBox = giftBox;
    }

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    public BigDecimal getDealerRetailPrice() {
        return dealerRetailPrice;
    }

    public void setDealerRetailPrice(BigDecimal dealerRetailPrice) {
        this.dealerRetailPrice = dealerRetailPrice;
    }

    public String getExternalCode() {
        return externalCode;
    }

    public void setExternalCode(String externalCode) {
        this.externalCode = externalCode;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }
}
