package com.yx.tcbj.center.api;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.api.dto.request.ItemInterceptDetailReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
 * 经销商产品商家拦截配置表服务接口
 *
 * @author ghosn
 * @since 2024-06-21
 */
@Api(tags = {"商家产品商家拦截配置表服务"})
@FeignClient(
        contextId = "com-yx-tcbj-center-api-IItemInterceptConfigApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/item/intercept/detail",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemInterceptDetailApi {

    /**
     * 新增经销商产品商家拦截配置表
     *
     * @param addReqDto 经销商产品商家拦截配置表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增经销商产品商家拦截配置表", notes = "新增经销商产品商家拦截配置表")
    RestResponse<Long> addItemInterceptConfig(@RequestBody ItemInterceptDetailReqDto addReqDto);

    /**
     * 修改经销商产品商家拦截配置表
     *
     * @param modifyReqDto 经销商产品商家拦截配置表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改经销商产品商家拦截配置表", notes = "修改经销商产品商家拦截配置表")
    RestResponse<Void> modifyItemInterceptConfig(@RequestBody ItemInterceptDetailReqDto modifyReqDto);

    /**
     * 删除经销商产品商家拦截配置表
     *
     * @param ids        经销商产品商家拦截配置表删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除经销商产品商家拦截配置表", notes = "删除经销商产品商家拦截配置表")
    RestResponse<Void> removeItemInterceptConfig(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
