package com.yx.tcbj.center.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;

/**
* Eo对象
*
* @author ghosn
* @since 2024-06-24
*/
@ApiModel(value = "ItemInterceptConfigReqDto", description = "Eo对象")
public class ItemInterceptConfigReqDto extends RequestDto{
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  拦截类型；1：产品；2：品牌
    */
    @ApiModelProperty(name = "interceptType", value = "拦截类型；1：产品；2：品牌")
    private Integer interceptType;
    /**
    *  0：失效 1:启用
    */
    @ApiModelProperty(name = "status", value = "配置状态 0：失效 1:启用")
    private Integer status;

    /**
     *
     */
    @ApiModelProperty(name = "operateType", value = "业务操作 0：失效 1:启用")
    private Integer operateType;

    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     *  拦截内容；产品id&品牌id
     */
    @ApiModelProperty(name = "interceptContent", value = "拦截内容；产品id&品牌id")
    private List<String> interceptContents;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setInterceptType(Integer interceptType){
    this.interceptType = interceptType;
    }
    public Integer getInterceptType(){
    return this.interceptType;
    }
    public void setStatus(Integer status){
    this.status = status;
    }
    public Integer getStatus(){
    return this.status;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }

    public List<String> getInterceptContents() {
        return interceptContents;
    }

    public void setInterceptContents(List<String> interceptContents) {
        this.interceptContents = interceptContents;
    }

    public Integer getOperateType() {
        return operateType;
    }

    public void setOperateType(Integer operateType) {
        this.operateType = operateType;
    }
}
