package com.yx.tcbj.center.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.yx.tcbj.center.api.dto.request.ItemAuthBatchReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 供应商和产品的供货价格服务接口
 *
 * @author jianshi
 * @since 2021-11-11
 */
@Api(tags = {"商品中心:商品授权扩展相关"})
@FeignClient(
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemAuthExpand",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemAuthExpandApi {


    @PostMapping("/btachCustomerItemAuth")
    @ApiOperation(value = "批量客户商品授权", notes = "批量客户商品授权")
    RestResponse<Void> btachCustomerItemAuth(@RequestBody ItemAuthBatchReqDto itemAuthBatchReqDto);

    @PostMapping("/syncRuleToEsAll")
    @ApiOperation(value = "商品授权规则增量同步ES", notes = "商品授权规则增量同步ES")
    RestResponse<Void> syncRuleToEsAll(@RequestBody AuthItemRuleReqDto queryDto);

}
