package com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 客户指定授权商品VO
 */
@ApiModel(value = "CustomerAuthItemVo", description = "客户指定授权商品VO")
public class CustomerAuthItemVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 商品ID
     */
    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    /**
     * 商品SKU ID
     */
    @ApiModelProperty(value = "商品SKU ID")
    private Long skuId;
    
    /**
     * 客户ID
     */
    @ApiModelProperty(value = "客户ID")
    private Long customerId;
    
    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;
    
    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String customerName;

    /**
     * 商品名称
     */
    @ApiModelProperty(value = "商品名称")
    private String itemName;

    /**
     * 商品编码
     */
    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    /**
     * SKU编码
     */
    @ApiModelProperty(value = "SKU编码")
    private String skuCode;

    /**
     * 规格属性
     */
    @ApiModelProperty(value = "规格属性")
    private String specAttr;

    /**
     * 商品品牌
     */
    @ApiModelProperty(value = "商品品牌")
    private String brandName;

    /**
     * 商品类型
     */
    @ApiModelProperty(value = "商品类型")
    private Integer subType;

    /**
     * 禁售状态（1:启售，2:禁售）
     */
    @ApiModelProperty(value = "禁售状态（1:启售，2:禁售）")
    private Integer prohibiteStatus;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    // Getters and Setters
    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSpecAttr() {
        return specAttr;
    }

    public void setSpecAttr(String specAttr) {
        this.specAttr = specAttr;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Integer getProhibiteStatus() {
        return prohibiteStatus;
    }

    public void setProhibiteStatus(Integer prohibiteStatus) {
        this.prohibiteStatus = prohibiteStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
} 