package com.yx.tcbj.center.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author 迪迦
 * @date 2021-09-24
 */
@ApiModel(value = "ItemPricePageRespDto", description = "商品价格分页响应Dto")
public class ItemPricePageRespDto extends BaseRespDto {
    /**
     *  商品Id
     */
    @ApiModelProperty(name = "id", value = "商品Id")
    private Long id;

    /**
     *  商品图片链接
     */
    @ApiModelProperty(name = "imgPath", value = "商品图片链接")
    private String imgPath;

//    /**
//     *  后台类目
//     */
//    @ApiModelProperty(name = "dir", value = "后台类目")
//    private String dir;

    @ApiModelProperty(name = "directoryItemRespDtos", value = "后台类目")
    private List<DirectoryItemRespDto> directoryItemRespDtos;

    @ApiModelProperty(
            name = "dirNameList",
            value = "后端类目名称集合：[1级，2级，3级]形式"
    )
    private List<String> dirNameList = new ArrayList<>();

    @ApiModelProperty(name = "dirId", value = "后台类目Id")
    private Long dirId;

    /**
     *  品牌名称
     */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    /**
     *  规格与价格
     */
    @ApiModelProperty(name = "List<SpecsPriceRespDto>", value = "规格与价格")
    private List<SpecsPriceRespDto> specsPriceRespDtos = new ArrayList<>();

    /**
     *  客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    /**
     *  客户编码
     */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;

    /**
     *  所属店铺
     */
    @ApiModelProperty(name = "shopName", value = "所属店铺")
    private String shopName;

    /**
     *  更新时间
     */
    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private Date updateTime;

    /**
     * 商品显示名
     */
    @ApiModelProperty(name = "displayName", value = "商品显示名")
    private String displayName;

    /**
     * 商品编码编码
     */
    @ApiModelProperty(name = "code", value = "商品编码编码")
    private String code;

    /**
     * 商品子类型，1-产品，2-赠品，3-物料
     */
    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    /**
     * 规格
     */
    @ApiModelProperty(name = "attr", value = "规格")
    private String attr;

    /**
     * 零售价
     */
    @ApiModelProperty(name = "price", value = "规格")
    private String price;

    /**
     * 供货价
     */
    @ApiModelProperty(name = "supplyPrice", value = "供货价")
    private String supplyPrice;

    /**
     *  商品sku
     */
    @ApiModelProperty(name = "skuIds", value = "商品sku")
    private String skuIds;

    /**
     *  卖家（商家/大B）ID
     */
    @ApiModelProperty(name = "sellerId", value = "卖家（商家/大B）ID")
    private Long sellerId;

    /**
     *  店铺id
     */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    /**
     *  买家（客户/小B）ID
     */
    @ApiModelProperty(name = "customerId", value = "买家（客户/小B）ID")
    private Long customerId;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public List<String> getDirNameList() {
        return dirNameList;
    }

    public void setDirNameList(List<String> dirNameList) {
        this.dirNameList = dirNameList;
    }

    public List<DirectoryItemRespDto> getDirectoryItemRespDtos() {
        return directoryItemRespDtos;
    }

    public void setDirectoryItemRespDtos(List<DirectoryItemRespDto> directoryItemRespDtos) {
        this.directoryItemRespDtos = directoryItemRespDtos;
    }



    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getSkuIds() {
        return skuIds;
    }

    public void setSkuIds(String skuIds) {
        this.skuIds = skuIds;
    }

    public String getImgPath() {
        return imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public List<SpecsPriceRespDto> getSpecsPriceRespDtos() {
        return specsPriceRespDtos;
    }

    public void setSpecsPriceRespDtos(List<SpecsPriceRespDto> specsPriceRespDtos) {
        this.specsPriceRespDtos = specsPriceRespDtos;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getSupplyPrice() {
        return supplyPrice;
    }

    public void setSupplyPrice(String supplyPrice) {
        this.supplyPrice = supplyPrice;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
