package com.yx.tcbj.center.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemSkuAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemSkuAuthRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;
import java.util.Map;

/**
 * 商品SKU授权API接口
 * 
 * @author system
 * @date 2024-01-01
 */
@FeignClient(
        contextId = "com-yx-tcbj-center-api-IItemInterceptConfigApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/item/sku/auth",
        url = "${yundt.cube.center.item.api:}"
)
@Api(tags = "商品SKU授权API")
public interface IItemSkuAuthApi {

    /**
     * 批量更新SKU授权状态
     * 
     * @param skuIds SKU ID列表
     * @param organizationId 组织ID
     * @param authStatus 授权状态：0-未授权，1-已授权
     * @return 处理结果
     */
    @PostMapping("/batch-update-status")
    @ApiOperation(value = "批量更新SKU授权状态")
    RestResponse<Void> batchUpdateSkuAuthStatus(List<Long> skuIds, Long organizationId, Integer authStatus);

    /**
     * 查询SKU授权状态
     * 
     * @param skuIds SKU ID列表
     * @param organizationId 组织ID
     * @return SKU授权状态映射
     */
    @PostMapping("/query-status")
    @ApiOperation(value = "查询SKU授权状态")
    RestResponse<Map<Long, Integer>> querySkuAuthStatus(List<Long> skuIds, Long organizationId);

    /**
     * 根据组织ID查询已授权的SKU列表
     * 
     * @param organizationId 组织ID
     * @return 已授权的SKU ID列表
     */
    @GetMapping("/authorized-skus/{organizationId}")
    @ApiOperation(value = "根据组织ID查询已授权的SKU列表")
    RestResponse<List<Long>> queryAuthorizedSkuIds(Long organizationId);

    /**
     * 创建或更新SKU授权记录
     * 
     * @param reqDto 授权请求DTO
     * @return 处理结果
     */
    @PostMapping("/create-or-update")
    @ApiOperation(value = "创建或更新SKU授权记录")
    RestResponse<Void> createOrUpdateSkuAuth(ItemSkuAuthReqDto reqDto);
} 