package com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 客户授权商品查询请求DTO
 */
@ApiModel(value = "CustomerAuthItemPageReqDto", description = "客户授权商品查询请求DTO")
public class CustomerAuthItemPageReqDto {

    @NotNull(message = "店铺ID不能为空")
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @NotNull(message = "客户Id不能为空")
    @ApiModelProperty(name = "customerId", value = "客户Id")
    private Long customerId;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    
    /**
     * 商品编号
     */
    @ApiModelProperty(name = "itemCode", value = "商品编号")
    private String itemCode;
    
    /**
     * sku编码
     */
    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;
    
    /**
     * 后台类目
     */
    @ApiModelProperty(name = "dirIds", value = "后台类目")
    private List<Long> dirIds;
    
    /**
     * 商品品牌
     */
    @ApiModelProperty(name = "brandId", value = "商品品牌")
    private Long brandId;
    
    /**
     * 商品类型
     */
    @ApiModelProperty(name = "subType", value = "商品类型")
    private Integer subType;
    
    /**
     * 启售禁售状态（仅支持已授权商品）
     */
    @ApiModelProperty(name = "prohibiteStatus", value = "1.启售，2.禁售（仅支持已授权商品）")
    private Integer prohibiteStatus;

    /**
     * 1.已授权商品，2.未授权商品
     */
    @ApiModelProperty(name = "selectType", value = "1.已授权商品，2.未授权商品")
    private Integer selectType = 1;

    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    
    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum = 1;
    
    /**
     * 每页数量
     */
    @ApiModelProperty(name = "pageSize", value = "每页数量")
    private Integer pageSize = 10;
    
    /**
     * 匹配的SKU ID列表
     */
    @ApiModelProperty(name = "matchSkuIds", value = "匹配的SKU ID列表")
    private List<Long> matchSkuIds;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public List<Long> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<Long> dirIds) {
        this.dirIds = dirIds;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Integer getProhibiteStatus() {
        return prohibiteStatus;
    }

    public void setProhibiteStatus(Integer prohibiteStatus) {
        this.prohibiteStatus = prohibiteStatus;
    }

    public Integer getSelectType() {
        return selectType;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }
    
    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
    
    public List<Long> getMatchSkuIds() {
        return matchSkuIds;
    }

    public void setMatchSkuIds(List<Long> matchSkuIds) {
        this.matchSkuIds = matchSkuIds;
    }
} 